<?php

require_once(sfConfig::get('sf_lib_dir').'/filter/base/BaseFormFilterPropel.class.php');

/**
 * Lot filter form base class.
 *
 * @package    auction
 * @subpackage filter
 * @author     Your name here
 * @version    SVN: $Id: sfPropelFormFilterGeneratedTemplate.php 13459 2008-11-28 14:48:12Z fabien $
 */
class BaseLotFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'auction_type_id' => new sfWidgetFormPropelChoice(array('model' => 'AuctionType', 'add_empty' => true)),
      'product_id'      => new sfWidgetFormPropelChoice(array('model' => 'Product', 'add_empty' => true)),
      'dt_start'        => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => true)),
      'dt_end'          => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => true)),
      'dt_autobet'      => new sfWidgetFormFilterDate(array('from_date' => new sfWidgetFormDate(), 'to_date' => new sfWidgetFormDate(), 'with_empty' => true)),
      'is_closed'       => new sfWidgetFormChoice(array('choices' => array('' => 'yes or no', 1 => 'yes', 0 => 'no'))),
      'price'           => new sfWidgetFormFilterInput(),
      'user'            => new sfWidgetFormFilterInput(),
      'bet_last_id'     => new sfWidgetFormPropelChoice(array('model' => 'Bet', 'add_empty' => true)),
    ));

    $this->setValidators(array(
      'auction_type_id' => new sfValidatorPropelChoice(array('required' => false, 'model' => 'AuctionType', 'column' => 'id')),
      'product_id'      => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Product', 'column' => 'id')),
      'dt_start'        => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDate(array('required' => false)), 'to_date' => new sfValidatorDate(array('required' => false)))),
      'dt_end'          => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDate(array('required' => false)), 'to_date' => new sfValidatorDate(array('required' => false)))),
      'dt_autobet'      => new sfValidatorDateRange(array('required' => false, 'from_date' => new sfValidatorDate(array('required' => false)), 'to_date' => new sfValidatorDate(array('required' => false)))),
      'is_closed'       => new sfValidatorChoice(array('required' => false, 'choices' => array('', 1, 0))),
      'price'           => new sfValidatorSchemaFilter('text', new sfValidatorInteger(array('required' => false))),
      'user'            => new sfValidatorPass(array('required' => false)),
      'bet_last_id'     => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Bet', 'column' => 'id')),
    ));

    $this->widgetSchema->setNameFormat('lot_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'Lot';
  }

  public function getFields()
  {
    return array(
      'id'              => 'Number',
      'auction_type_id' => 'ForeignKey',
      'product_id'      => 'ForeignKey',
      'dt_start'        => 'Date',
      'dt_end'          => 'Date',
      'dt_autobet'      => 'Date',
      'is_closed'       => 'Boolean',
      'price'           => 'Number',
      'user'            => 'Text',
      'bet_last_id'     => 'ForeignKey',
    );
  }
}
