<?php

require_once(sfConfig::get('sf_lib_dir').'/filter/base/BaseFormFilterPropel.class.php');

/**
 * LotAuctionOption filter form base class.
 *
 * @package    auction
 * @subpackage filter
 * @author     Your name here
 * @version    SVN: $Id: sfPropelFormFilterGeneratedTemplate.php 13459 2008-11-28 14:48:12Z fabien $
 */
class BaseLotAuctionOptionFormFilter extends BaseFormFilterPropel
{
  public function setup()
  {
    $this->setWidgets(array(
      'lot_id'            => new sfWidgetFormPropelChoice(array('model' => 'Lot', 'add_empty' => true)),
      'auction_option_id' => new sfWidgetFormPropelChoice(array('model' => 'AuctionOption', 'add_empty' => true)),
      'content'           => new sfWidgetFormFilterInput(),
    ));

    $this->setValidators(array(
      'lot_id'            => new sfValidatorPropelChoice(array('required' => false, 'model' => 'Lot', 'column' => 'id')),
      'auction_option_id' => new sfValidatorPropelChoice(array('required' => false, 'model' => 'AuctionOption', 'column' => 'id')),
      'content'           => new sfValidatorPass(array('required' => false)),
    ));

    $this->widgetSchema->setNameFormat('lot_auction_option_filters[%s]');

    $this->errorSchema = new sfValidatorErrorSchema($this->validatorSchema);

    parent::setup();
  }

  public function getModelName()
  {
    return 'LotAuctionOption';
  }

  public function getFields()
  {
    return array(
      'id'                => 'Number',
      'lot_id'            => 'ForeignKey',
      'auction_option_id' => 'ForeignKey',
      'content'           => 'Text',
    );
  }
}
