<?php

/**
 * sfGuardUser module configuration.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage sfGuardUser
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: configuration.php 12831 2008-11-09 14:33:38Z fabien $
 */
class BaseSfGuardUserGeneratorConfiguration extends sfModelGeneratorConfiguration
{
  public function getCredentials($action)
  {
    if (0 === strpos($action, '_'))
    {
      $action = substr($action, 1);
    }

    return isset($this->configuration['credentials'][$action]) ? $this->configuration['credentials'][$action] : array();
  }

  public function getActionsDefault()
  {
    return array();
  }

  public function getFormActions()
  {
    return array(  '_delete' => NULL,  '_list' => NULL,  '_save' => NULL,  '_save_and_add' => NULL,);
  }

  public function getNewActions()
  {
    return array();
  }

  public function getEditActions()
  {
    return array();
  }

  public function getListObjectActions()
  {
    return array(  '_edit' => NULL,  '_delete' => NULL,);
  }

  public function getListActions()
  {
    return array(  '_new' => NULL,);
  }

  public function getListBatchActions()
  {
    return array(  '_delete' => NULL,);
  }

  public function getListParams()
  {
    return '%%id%% - %%username%% - %%created_at%% - %%last_login%% - %%is_active%% - %%balance_bets%% - %%balance_money%%';
  }

  public function getListLayout()
  {
    return 'tabular';
  }

  public function getListTitle()
  {
    return 'Список пользователей';
  }

  public function getEditTitle()
  {
    return 'Редактирование пользователя "%%username%%"';
  }

  public function getNewTitle()
  {
    return 'Добавление пользователя';
  }

  public function getFilterDisplay()
  {
    return array(  0 => 'username',  1 => 'email',  2 => 'is_active',  3 => 'is_bot',);
  }

  public function getFormDisplay()
  {
    return array(  'NONE' =>   array(    0 => 'username',    1 => 'password',    2 => 'password_again',    3 => 'email',    4 => 'phone',  ),  'Права доступа' =>   array(    0 => 'is_active',    1 => 'is_super_admin',    2 => 'is_bot',    3 => 'sf_guard_user_permission_list',  ),  'Счет' =>   array(    0 => 'balance_bets',    1 => 'balance_money',  ),  'Рейтинг' =>   array(    0 => 'rating',    1 => 'rating_week',  ),  'Личное' =>   array(    0 => 'name',    1 => 'avatar',  ),  'Партнер' =>   array(    0 => 'balance_partner_total',    1 => 'balance_partner_used',  ),);
  }

  public function getEditDisplay()
  {
    return array();
  }

  public function getNewDisplay()
  {
    return array();
  }

  public function getListDisplay()
  {
    return array(  0 => 'id',  1 => 'username',  2 => 'created_at',  3 => 'last_login',  4 => 'is_active',  5 => 'balance_bets',  6 => 'balance_money',);
  }

  public function getFieldsDefault()
  {
    return array(
      'id' => array(  'is_link' => true,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'user_partner_id' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'ForeignKey',),
      'username' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Логин',),
      'title' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'algorithm' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'salt' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'password' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Пароль',),
      'created_at' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Date',  'label' => 'Дата регистрации',),
      'email' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'E-Mail',),
      'phone' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Телефон',),
      'last_login' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Date',  'label' => 'Последняя активность',),
      'is_active' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Boolean',  'label' => 'Включен?',),
      'is_super_admin' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Boolean',  'label' => 'Суперадмин?',),
      'is_bot' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Boolean',  'label' => 'Бот?',),
      'is_winner' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Boolean',),
      'balance_bets' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Кол-во ставок',),
      'balance_money' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Сумма ваучеров',),
      'name' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'avatar' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'rating' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'rating_week' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'sf_guard_user_group_list' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'sf_guard_user_permission_list' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'password_again' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Пароль (снова)',),
      'sf_guard_user_permission_list { label' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
    );
  }

  public function getFieldsList()
  {
    return array(
      'id' => array(),
      'user_partner_id' => array(),
      'username' => array(),
      'title' => array(),
      'algorithm' => array(),
      'salt' => array(),
      'password' => array(),
      'created_at' => array(),
      'email' => array(),
      'phone' => array(),
      'last_login' => array(),
      'is_active' => array(),
      'is_super_admin' => array(),
      'is_bot' => array(),
      'is_winner' => array(),
      'balance_bets' => array(),
      'balance_money' => array(),
      'name' => array(),
      'avatar' => array(),
      'rating' => array(),
      'rating_week' => array(),
      'sf_guard_user_group_list' => array(),
      'sf_guard_user_permission_list' => array(),
    );
  }

  public function getFieldsFilter()
  {
    return array(
      'id' => array(),
      'user_partner_id' => array(),
      'username' => array(),
      'title' => array(),
      'algorithm' => array(),
      'salt' => array(),
      'password' => array(),
      'created_at' => array(),
      'email' => array(),
      'phone' => array(),
      'last_login' => array(),
      'is_active' => array(),
      'is_super_admin' => array(),
      'is_bot' => array(),
      'is_winner' => array(),
      'balance_bets' => array(),
      'balance_money' => array(),
      'name' => array(),
      'avatar' => array(),
      'rating' => array(),
      'rating_week' => array(),
      'sf_guard_user_group_list' => array(),
      'sf_guard_user_permission_list' => array(),
    );
  }

  public function getFieldsForm()
  {
    return array(
      'id' => array(),
      'user_partner_id' => array(),
      'username' => array(),
      'title' => array(),
      'algorithm' => array(),
      'salt' => array(),
      'password' => array(),
      'created_at' => array(),
      'email' => array(),
      'phone' => array(),
      'last_login' => array(),
      'is_active' => array(),
      'is_super_admin' => array(),
      'is_bot' => array(),
      'is_winner' => array(),
      'balance_bets' => array(),
      'balance_money' => array(),
      'name' => array(),
      'avatar' => array(),
      'rating' => array(),
      'rating_week' => array(),
      'sf_guard_user_group_list' => array(),
      'sf_guard_user_permission_list' => array(),
    );
  }

  public function getFieldsEdit()
  {
    return array(
      'id' => array(),
      'user_partner_id' => array(),
      'username' => array(),
      'title' => array(),
      'algorithm' => array(),
      'salt' => array(),
      'password' => array(),
      'created_at' => array(),
      'email' => array(),
      'phone' => array(),
      'last_login' => array(),
      'is_active' => array(),
      'is_super_admin' => array(),
      'is_bot' => array(),
      'is_winner' => array(),
      'balance_bets' => array(),
      'balance_money' => array(),
      'name' => array(),
      'avatar' => array(),
      'rating' => array(),
      'rating_week' => array(),
      'sf_guard_user_group_list' => array(),
      'sf_guard_user_permission_list' => array(),
    );
  }

  public function getFieldsNew()
  {
    return array(
      'id' => array(),
      'user_partner_id' => array(),
      'username' => array(),
      'title' => array(),
      'algorithm' => array(),
      'salt' => array(),
      'password' => array(),
      'created_at' => array(),
      'email' => array(),
      'phone' => array(),
      'last_login' => array(),
      'is_active' => array(),
      'is_super_admin' => array(),
      'is_bot' => array(),
      'is_winner' => array(),
      'balance_bets' => array(),
      'balance_money' => array(),
      'name' => array(),
      'avatar' => array(),
      'rating' => array(),
      'rating_week' => array(),
      'sf_guard_user_group_list' => array(),
      'sf_guard_user_permission_list' => array(),
    );
  }


  public function getForm($object = null)
  {
    $class = $this->getFormClass();

    return new $class($object, $this->getFormOptions());
  }

  /**
   * Gets the form class name.
   *
   * @return string The form class name
   */
  public function getFormClass()
  {
    return 'sfGuardUserAdminForm';
  }

  public function getFormOptions()
  {
    return array();
  }

  public function hasFilterForm()
  {
    return true;
  }

  /**
   * Gets the filter form class name
   *
   * @return string The filter form class name associated with this generator
   */
  public function getFilterFormClass()
  {
    return 'sfGuardUserFormFilter';
  }

  public function getFilterForm($filters)
  {
    $class = $this->getFilterFormClass();

    return new $class($filters, $this->getFilterFormOptions());
  }

  public function getFilterFormOptions()
  {
    return array();
  }

  public function getFilterDefaults()
  {
    return array();
  }

  public function getPager($model)
  {
    $class = $this->getPagerClass();

    return new $class($model, $this->getPagerMaxPerPage());
  }

  public function getPagerClass()
  {
    return 'sfPropelPager';
  }

  public function getPagerMaxPerPage()
  {
    return 20;
  }

  public function getDefaultSort()
  {
    return array(null, null);
  }

  public function getPeerMethod()
  {
    return 'doSelect';
  }

  public function getPeerCountMethod()
  {
    return 'doCount';
  }

  public function getConnection()
  {
    return null;
  }
}
