<?php

/**
 * product module configuration.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage product
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: configuration.php 12831 2008-11-09 14:33:38Z fabien $
 */
class BaseProductGeneratorConfiguration extends sfModelGeneratorConfiguration
{
  public function getCredentials($action)
  {
    if (0 === strpos($action, '_'))
    {
      $action = substr($action, 1);
    }

    return isset($this->configuration['credentials'][$action]) ? $this->configuration['credentials'][$action] : array();
  }

  public function getActionsDefault()
  {
    return array();
  }

  public function getFormActions()
  {
    return array(  '_delete' => NULL,  '_list' => NULL,  '_save' => NULL,  '_save_and_add' => NULL,);
  }

  public function getNewActions()
  {
    return array();
  }

  public function getEditActions()
  {
    return array();
  }

  public function getListObjectActions()
  {
    return array(  '_edit' => NULL,  '_delete' => NULL,);
  }

  public function getListActions()
  {
    return array(  '_new' => NULL,);
  }

  public function getListBatchActions()
  {
    return array(  '_delete' => NULL,);
  }

  public function getListParams()
  {
    return '%%id%% - %%category_title%% - %%title%% - %%description_short%% - %%price%%';
  }

  public function getListLayout()
  {
    return 'tabular';
  }

  public function getListTitle()
  {
    return 'Список товаров';
  }

  public function getEditTitle()
  {
    return 'Редактирование товара';
  }

  public function getNewTitle()
  {
    return 'Создание товара';
  }

  public function getFilterDisplay()
  {
    return array(  0 => 'category_id',  1 => 'title',);
  }

  public function getFormDisplay()
  {
    return array();
  }

  public function getEditDisplay()
  {
    return array();
  }

  public function getNewDisplay()
  {
    return array();
  }

  public function getListDisplay()
  {
    return array(  0 => 'id',  1 => 'category_title',  2 => 'title',  3 => 'description_short',  4 => 'price',);
  }

  public function getFieldsDefault()
  {
    return array(
      'id' => array(  'is_link' => true,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'category_id' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'ForeignKey',  'label' => 'Категория',),
      'title' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Название',  'attributes' =>   array(    'style' => 'width: 350px',  ),),
      'title_full' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Полное название',  'attributes' =>   array(    'style' => 'width: 350px',  ),),
      'description_short' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Краткое описание',  'attributes' =>   array(    'style' => 'width: 500px',  ),),
      'description_full' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Полное описание',  'attributes' =>   array(    'class' => 'TinyMCE',  ),),
      'price' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Реальная цена',  'attributes' =>   array(    'style' => 'width: 80px',  ),),
      'image_main' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Главная картинка (237x167)',),
      'image_main_thumb' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Превью главной картинки (90x90)',),
      'image_icon' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Иконка (80x45)',),
      'image1' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Картинка #1',),
      'image1_thumb' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Картинка #1 (превью)',),
      'image2' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Картинка #2',),
      'image2_thumb' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Картинка #2 (превью)',),
      'image3' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Картинка #3',),
      'image3_thumb' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Картинка #3 (превью)',),
      'image4' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Картинка #4',),
      'image4_thumb' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Картинка #4 (превью)',),
      'category_title' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Категория',),
    );
  }

  public function getFieldsList()
  {
    return array(
      'id' => array(),
      'category_id' => array(),
      'title' => array(),
      'title_full' => array(),
      'description_short' => array(),
      'description_full' => array(),
      'price' => array(),
      'image_main' => array(),
      'image_main_thumb' => array(),
      'image_icon' => array(),
      'image1' => array(),
      'image1_thumb' => array(),
      'image2' => array(),
      'image2_thumb' => array(),
      'image3' => array(),
      'image3_thumb' => array(),
      'image4' => array(),
      'image4_thumb' => array(),
    );
  }

  public function getFieldsFilter()
  {
    return array(
      'id' => array(),
      'category_id' => array(  'attributes' =>   array(    'style' => 'width: 150px;',  ),),
      'title' => array(  'attributes' =>   array(    'style' => 'width: 150px;',  ),),
      'title_full' => array(  'attributes' =>   array(    'style' => 'width: 150px;',  ),),
      'description_short' => array(),
      'description_full' => array(),
      'price' => array(),
      'image_main' => array(),
      'image_main_thumb' => array(),
      'image_icon' => array(),
      'image1' => array(),
      'image1_thumb' => array(),
      'image2' => array(),
      'image2_thumb' => array(),
      'image3' => array(),
      'image3_thumb' => array(),
      'image4' => array(),
      'image4_thumb' => array(),
    );
  }

  public function getFieldsForm()
  {
    return array(
      'id' => array(),
      'category_id' => array(),
      'title' => array(),
      'title_full' => array(),
      'description_short' => array(),
      'description_full' => array(),
      'price' => array(),
      'image_main' => array(),
      'image_main_thumb' => array(),
      'image_icon' => array(),
      'image1' => array(),
      'image1_thumb' => array(),
      'image2' => array(),
      'image2_thumb' => array(),
      'image3' => array(),
      'image3_thumb' => array(),
      'image4' => array(),
      'image4_thumb' => array(),
    );
  }

  public function getFieldsEdit()
  {
    return array(
      'id' => array(),
      'category_id' => array(),
      'title' => array(),
      'title_full' => array(),
      'description_short' => array(),
      'description_full' => array(),
      'price' => array(),
      'image_main' => array(),
      'image_main_thumb' => array(),
      'image_icon' => array(),
      'image1' => array(),
      'image1_thumb' => array(),
      'image2' => array(),
      'image2_thumb' => array(),
      'image3' => array(),
      'image3_thumb' => array(),
      'image4' => array(),
      'image4_thumb' => array(),
    );
  }

  public function getFieldsNew()
  {
    return array(
      'id' => array(),
      'category_id' => array(),
      'title' => array(),
      'title_full' => array(),
      'description_short' => array(),
      'description_full' => array(),
      'price' => array(),
      'image_main' => array(),
      'image_main_thumb' => array(),
      'image_icon' => array(),
      'image1' => array(),
      'image1_thumb' => array(),
      'image2' => array(),
      'image2_thumb' => array(),
      'image3' => array(),
      'image3_thumb' => array(),
      'image4' => array(),
      'image4_thumb' => array(),
    );
  }


  public function getForm($object = null)
  {
    $class = $this->getFormClass();

    return new $class($object, $this->getFormOptions());
  }

  /**
   * Gets the form class name.
   *
   * @return string The form class name
   */
  public function getFormClass()
  {
    return 'ProductForm';
  }

  public function getFormOptions()
  {
    return array();
  }

  public function hasFilterForm()
  {
    return true;
  }

  /**
   * Gets the filter form class name
   *
   * @return string The filter form class name associated with this generator
   */
  public function getFilterFormClass()
  {
    return 'ProductFormFilter';
  }

  public function getFilterForm($filters)
  {
    $class = $this->getFilterFormClass();

    return new $class($filters, $this->getFilterFormOptions());
  }

  public function getFilterFormOptions()
  {
    return array();
  }

  public function getFilterDefaults()
  {
    return array();
  }

  public function getPager($model)
  {
    $class = $this->getPagerClass();

    return new $class($model, $this->getPagerMaxPerPage());
  }

  public function getPagerClass()
  {
    return 'sfPropelPager';
  }

  public function getPagerMaxPerPage()
  {
    return 20;
  }

  public function getDefaultSort()
  {
    return array(null, null);
  }

  public function getPeerMethod()
  {
    return 'doSelect';
  }

  public function getPeerCountMethod()
  {
    return 'doCount';
  }

  public function getConnection()
  {
    return null;
  }
}
