<?php

/**
 * lot module configuration.
 *
 * @package    ##PROJECT_NAME##
 * @subpackage lot
 * @author     ##AUTHOR_NAME##
 * @version    SVN: $Id: configuration.php 12831 2008-11-09 14:33:38Z fabien $
 */
class BaseLotGeneratorConfiguration extends sfModelGeneratorConfiguration
{
  public function getCredentials($action)
  {
    if (0 === strpos($action, '_'))
    {
      $action = substr($action, 1);
    }

    return isset($this->configuration['credentials'][$action]) ? $this->configuration['credentials'][$action] : array();
  }

  public function getActionsDefault()
  {
    return array();
  }

  public function getFormActions()
  {
    return array(  '_delete' => NULL,  '_list' => NULL,  '_save' => NULL,  '_save_and_add' => NULL,);
  }

  public function getNewActions()
  {
    return array();
  }

  public function getEditActions()
  {
    return array();
  }

  public function getListObjectActions()
  {
    return array(  '_edit' => NULL,  '_delete' => NULL,);
  }

  public function getListActions()
  {
    return array(  '_new' => NULL,);
  }

  public function getListBatchActions()
  {
    return array(  '_delete' => NULL,);
  }

  public function getListParams()
  {
    return '%%id%% - %%product_title%% - %%dt_start%% - %%dt_end%% - %%is_closed%%';
  }

  public function getListLayout()
  {
    return 'tabular';
  }

  public function getListTitle()
  {
    return 'Список лотов';
  }

  public function getEditTitle()
  {
    return 'Редактирование лота';
  }

  public function getNewTitle()
  {
    return 'Новый лот';
  }

  public function getFilterDisplay()
  {
    return array(  0 => 'auction_type_id',  1 => 'product_id',  2 => 'is_closed',);
  }

  public function getFormDisplay()
  {
    return array();
  }

  public function getEditDisplay()
  {
    return array(  0 => 'auction_type_id',  1 => 'product_id',  2 => 'dt_start',  3 => 'dt_end',  4 => 'price',  5 => 'is_closed',);
  }

  public function getNewDisplay()
  {
    return array(  0 => 'auction_type_id',  1 => 'product_id',  2 => 'dt_start',  3 => 'is_closed',);
  }

  public function getListDisplay()
  {
    return array(  0 => 'id',  1 => 'product_title',  2 => 'dt_start',  3 => 'dt_end',  4 => 'is_closed',);
  }

  public function getFieldsDefault()
  {
    return array(
      'id' => array(  'is_link' => true,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'auction_type_id' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'ForeignKey',  'label' => 'Тип аукциона',),
      'product_id' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'ForeignKey',  'label' => 'Товар',),
      'dt_start' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Date',  'label' => 'Время начала',),
      'dt_end' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Date',  'label' => 'Время завершения',),
      'dt_autobet' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Date',),
      'is_closed' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Boolean',  'label' => 'Окончен?',),
      'price' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'user' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',),
      'bet_last_id' => array(  'is_link' => false,  'is_real' => true,  'is_partial' => false,  'is_component' => false,  'type' => 'ForeignKey',),
      'product_title' => array(  'is_link' => false,  'is_real' => false,  'is_partial' => false,  'is_component' => false,  'type' => 'Text',  'label' => 'Товар',),
    );
  }

  public function getFieldsList()
  {
    return array(
      'id' => array(),
      'auction_type_id' => array(),
      'product_id' => array(),
      'dt_start' => array(),
      'dt_end' => array(),
      'dt_autobet' => array(),
      'is_closed' => array(),
      'price' => array(),
      'user' => array(),
      'bet_last_id' => array(),
    );
  }

  public function getFieldsFilter()
  {
    return array(
      'id' => array(),
      'auction_type_id' => array(  'attributes' =>   array(    'style' => 'width: 150px;',  ),),
      'product_id' => array(  'attributes' =>   array(    'style' => 'width: 150px;',  ),),
      'dt_start' => array(),
      'dt_end' => array(),
      'dt_autobet' => array(),
      'is_closed' => array(),
      'price' => array(),
      'user' => array(),
      'bet_last_id' => array(),
    );
  }

  public function getFieldsForm()
  {
    return array(
      'id' => array(),
      'auction_type_id' => array(),
      'product_id' => array(),
      'dt_start' => array(),
      'dt_end' => array(),
      'dt_autobet' => array(),
      'is_closed' => array(),
      'price' => array(),
      'user' => array(),
      'bet_last_id' => array(),
    );
  }

  public function getFieldsEdit()
  {
    return array(
      'id' => array(),
      'auction_type_id' => array(),
      'product_id' => array(),
      'dt_start' => array(),
      'dt_end' => array(),
      'dt_autobet' => array(),
      'is_closed' => array(),
      'price' => array(),
      'user' => array(),
      'bet_last_id' => array(),
    );
  }

  public function getFieldsNew()
  {
    return array(
      'id' => array(),
      'auction_type_id' => array(),
      'product_id' => array(),
      'dt_start' => array(),
      'dt_end' => array(),
      'dt_autobet' => array(),
      'is_closed' => array(),
      'price' => array(),
      'user' => array(),
      'bet_last_id' => array(),
    );
  }


  public function getForm($object = null)
  {
    $class = $this->getFormClass();

    return new $class($object, $this->getFormOptions());
  }

  /**
   * Gets the form class name.
   *
   * @return string The form class name
   */
  public function getFormClass()
  {
    return 'LotForm';
  }

  public function getFormOptions()
  {
    return array();
  }

  public function hasFilterForm()
  {
    return true;
  }

  /**
   * Gets the filter form class name
   *
   * @return string The filter form class name associated with this generator
   */
  public function getFilterFormClass()
  {
    return 'LotFormFilter';
  }

  public function getFilterForm($filters)
  {
    $class = $this->getFilterFormClass();

    return new $class($filters, $this->getFilterFormOptions());
  }

  public function getFilterFormOptions()
  {
    return array();
  }

  public function getFilterDefaults()
  {
    return array();
  }

  public function getPager($model)
  {
    $class = $this->getPagerClass();

    return new $class($model, $this->getPagerMaxPerPage());
  }

  public function getPagerClass()
  {
    return 'sfPropelPager';
  }

  public function getPagerMaxPerPage()
  {
    return 20;
  }

  public function getDefaultSort()
  {
    return array(null, null);
  }

  public function getPeerMethod()
  {
    return 'doSelect';
  }

  public function getPeerCountMethod()
  {
    return 'doCount';
  }

  public function getConnection()
  {
    return null;
  }
}
