<?php 

function isCurrent($menuItem)
{
    $request = sfContext::getInstance()->getRequest();
    
    if (!$menuItem || !array_key_exists('url', $menuItem))
        return false;
    
    return strpos($request->getPathInfo(), $menuItem['url']) === 0 && ($request->getPathInfo() == '/' || $menuItem['url'] != '/');
}

?>

<?php $menuItems = $sf_user->isMember() ? sfConfig::get('app_menu_upper_member') : sfConfig::get('app_menu_upper_guest'); ?>

<div id="top_menu">
<ul>

<?php for ($i = 0; $i < count($menuItems); $i++) { ?>

    <li<?=isCurrent($menuItems[$i]) ? ' class="cur"' : ''?>>
        <?php if (0 == $i) { ?>
            <img src="/images/top_menu_left<?=isCurrent($menuItems[$i]) ? '_cur' : ''?>.jpg" width="11" height="27" alt="" />
        <?php } ?>

        <?php if (array_key_exists('inactive', $menuItems[$i]) && !!$menuItems[$i]['inactive']) { ?>
            <span<?=0 == $i ? ' class="first"' : ''?><?=count($menuItems)-1 == $i ? ' class="last"' : ''?>><a href="#" onclick="return false;"><?=$menuItems[$i]['title']?></a></span>
        <?php } else { ?>
            <span<?=0 == $i ? ' class="first"' : ''?><?=count($menuItems)-1 == $i ? ' class="last"' : ''?>><a href="<?=url_for($menuItems[$i]['url_internal'])?>"><?=$menuItems[$i]['title']?></a></span>
        <?php } ?>
        
        <?php if (count($menuItems)-1 == $i) { ?>
            <img src="/images/top_menu_right<?=isCurrent($menuItems[$i]) ? '_cur' : ''?>.jpg" width="11" height="27" alt="" />
        <?php } else { ?>
            <img src="/images/top_menu_separ<?=isCurrent($menuItems[$i]) ? '_cur_right' : ''?><?=isCurrent($menuItems[$i+1]) ? '_cur_left' : ''?>.jpg" width="7" height="27" alt="" />        
        <?php } ?>
    
    </li>

<?php } ?>

</ul>
</div>