<?php slot('page_title') ?>
    <?=$pageTitle?>
<?php end_slot(); ?>

<?php slot('breadcrumb') ?>
    <?php include_partial('global/breadcrumb', array('breadcrumb' => $breadcrumb)); ?>
<?php end_slot(); ?>

<?php slot('sidebar_left_wide') ?>

    <div style="float: left; width: 220px;">

        <?php
            $avatar = $user->getAvatar() ? '/uploads/avatars/' . $user->getAvatar() : sfConfig::get('app_profile_avatar_default');
            $avatarSize = sfCacheManager::getImageSize($avatar);
        ?>

        <img class="avatar_big" src="<?=$avatar?>" width="<?=$avatarSize[0]?>" height="<?=$avatarSize[1]?>" alt="" />

        <br /><br />

        <div align="left" style="margin-top: 5px;">

            Имя: <strong><?=$user->getName() ? htmlspecialchars($user->getName()) : 'не указано'?></strong>

            <br />

            Регистрация: <strong><?=$user->getCreatedAtFormatted()?></strong>

            <br />

            <?php /* if ($user->isOnline()) { ?>

                <br />
                <span style="color: #74A600; font-weight: bold;">Сейчас на сайте!</span>

            <?php } else { ?>

                Был на сайте: <strong><?=$user->getLastLoginFormatted()?></strong>

            <?php } */ ?>

            <br /><br />

            <table cellpadding="0" cellspacing="0">
            <tr>
                <td width="110" align="right" valign="middle">Рейтинг&nbsp;&nbsp;</td>
                <td valign="top"><div class="big_green" style="margin-left: 5px;"><?=$user->getRatingFormatted()?></div></td>
            </tr>
            </table>
            <table cellpadding="0" cellspacing="0">
            <tr><td colspan="2"><div style="height: 15px;"><!-- --></div></td></tr>
            <tr>
                <td width="110" align="right" valign="middle">Текущая неделя&nbsp;&nbsp;</td>
                <td valign="top"><div class="big_green" style="margin-left: 5px;"><?=$user->getRatingWeekFormatted()?></div></td>
            </tr>
            </table>

        </div>

    </div>

<?php end_slot(); ?>

<?php if ($auctionsWon) { ?>

    <h4>Выигранные аукционы</h4>

    <br />

    <div class="table_list_container">

        <table cellpadding="0" cellspacing="0" width="100%" class="table_list">
            <tr bgcolor="#D9D9D9">
                <td><strong>Аукцион</strong></td>
                <td align="center"><strong>Дата окончания</strong></td>
                <td align="center"><strong>Стоимость</strong></td>
                <td align="center"><strong>Экономия</strong></td>
            </tr>

            <?php foreach ($auctionsWon as $lot) { $product = sfCacheManager::getObject('Product', $lot->getProductId()); ?>

                <tr>
                    <td style="font-size:11px;">
                        <a href="<?=url_for('Auction/view?lotId=' . $lot->getId())?>" class="a"><?=$product->getTitle()?></a><br /><br style="font-size:3px;" />
                    </td>
                    <td align="center"><?=$lot->getDtEndFormatted()?></td>
                    <td align="center"><?=$lot->getPriceFormatted()?></td>
                    <td align="center"><strong><?=$lot->getWinnerProfitPercentage()?>%</strong></td>
                </tr>

            <?php } ?>

        </table>

        <br /><br />

    </div>

<?php } ?>

<h4>Последние аукционы пользователя</h4>

<?php if ($auctions) { ?>
    <br />

    <div class="table_list_container">

        <table cellpadding="0" cellspacing="0" width="100%" class="table_list">
            <tr bgcolor="#D9D9D9">
                <td><strong>Аукцион</strong></td>
                <td align="center"><strong>Дата проведения</strong></td>
            </tr>

            <?php foreach ($auctions as $lot) { $product = sfCacheManager::getObject('Product', $lot->getProductId()); ?>

                <tr>
                    <td style="font-size:11px;">
                        <a href="<?=url_for('Auction/view?lotId=' . $lot->getId())?>" class="a"><?=$product->getTitle()?></a><br /><br style="font-size:3px;" />
                    </td>
                    <td align="center"><?=$lot->getDtStartFormatted()?></td>
                </tr>

            <?php } ?>

        </table>

    </div>

<?php } else { ?>

    <p>Пользователь пока не участвовал в аукционах.</p>

<?php } ?>