<?php slot('page_title') ?>
    <?=$pageTitle?>
<?php end_slot(); ?>

<?php slot('breadcrumb') ?>
    <?php include_partial('global/breadcrumb', array('breadcrumb' => $breadcrumb)); ?>
<?php end_slot(); ?>

<?php slot('sidebar_left') ?>
    <?php include_partial('User/menu', array('menu' => sfConfig::get('app_menu_member'))); ?>
<?php end_slot(); ?>

<?php if ($pager->getNbResults()) { ?>

    <div class="table_list_container">

    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="table_list">
        <tr bgcolor="#D9D9D9">
            <td colspan="2"><strong>Разыгрывался</strong></td>
            <td align="center"><strong>Завершен</strong></td>
            <td align="center"><strong>Стоимость</strong></td>
            <td align="center"><strong>Экономия</strong></td>
        </tr>

        <?php foreach ($pager->getResults() as $lot) { $product = sfCacheManager::getObject('Product', $lot->getProductId()) ?>

            <tr>
                <td style="border-bottom: none;" valign="top">
                    <img src="/uploads/products/<?=$product->getImageIcon()?>" alt="" align="left" />
                </td>
                <td style="font-size:11px; border-bottom: none;">
                    <a href="<?=url_for('Auction/view?lotId=' . $lot->getId())?>" class="a"><?=$product->getTitle()?></a><br /><br style="font-size:3px;" />
                </td>
                <td style="border-bottom: none;" align="center" width="120"><?=$lot->getDtEndFormatted()?></td>
                <td style="border-bottom: none;" align="center" width="140"><span style="display:table-cell; background:#74A600;font-size:18px;color:#FFFFFF;white-space: nowrap;padding:5px 15px;"><strong id="lot_<?=$lot->getId()?>_price"><?=$lot->getPriceFormatted()?> руб.</strong></span></td>
                <td style="border-bottom: none;" align="center"><strong class="strong"><?=$lot->getWinnerProfitPercentage()?>%</strong></td>
            </tr>

        <?php } ?>

    </table>

    </div>

    <?php if ($pager->haveToPaginate()) { ?>

        <br /><br />

        <div class="paging">

            <?php if ($pager->getPage() > 1) { ?>
                <?=link_to('предыдущая', '@auction_list_page?page=' . $pager->getPreviousPage())?>
            <?php } ?>

            <?php foreach ($pager->getLinks() as $page) { ?>

                <?php if ($page == $pager->getPage()) { ?>
                    <span><?=$page?></span>
                <?php } else { ?>
                    <?=link_to($page, '@auction_list_page?page=' . $page)?>
                <?php } ?>

            <?php } ?>

            <?php if ($pager->getLastPage() != $pager->getPage()) { ?>
                <?=link_to('следующая', '@auction_list_page?page=' . $pager->getNextPage())?>
            <?php } ?>

        </div>

    <?php } ?>

<?php } else { ?>

    <br />Удивительно, но Вы пока не выиграли ни одного аукциона!

<?php } ?>