<?php slot('page_title') ?>
    <?=$pageTitle?>
<?php end_slot(); ?>

<?php slot('breadcrumb') ?>
    <?php include_partial('global/breadcrumb', array('breadcrumb' => $breadcrumb)); ?>
<?php end_slot(); ?>

<?php slot('sidebar_left') ?>
    <?php include_partial('User/menu', array('menu' => sfConfig::get('app_menu_member'))); ?>
<?php end_slot(); ?>

<div id="list_tab">
    <?=link_to('Активные', '@user_auctions_list_my')?>
    <span>Завершенные</span>
</div>

<div class="table_list_container">

<?php if ($pager->getNbResults()) { ?>

    <script type="text/javascript">
        var userId = <?=$sf_user->isMember() ? $sf_user->getGuardUser()->getId(): '-1'?>;

        $(document).ready(function () {
            if (null === lots.updaterTimer)
                lots.updater();
        });
    </script>

    <table cellpadding="0" cellspacing="0" width="100%" class="table_list">
        <tr bgcolor="#D9D9D9">
            <td colspan="2"><strong>Разыгрывался</strong></td>
            <td align="center"><strong>Завершен</strong></td>
            <td align="center"><strong>Стоимость</strong></td>
            <td align="center"><strong>Экономия</strong></td>
        </tr>

        <?php foreach ($pager->getResults() as $lot) { $product = sfCacheManager::getObject('Product', $lot->getProductId()); ?>

            <tr>
                <td valign="top">
                    <img src="/uploads/products/<?=$product->getImageIcon()?>" alt="" />
                </td>
                <td style="font-size:11px;">
                    <a href="<?=url_for('Auction/view?lotId=' . $lot->getId())?>" class="a"><?=$product->getTitle()?></a><br /><br style="font-size:3px;" />
                </td>
                <td align="center" width="120"><?=$lot->getDtEndFormatted()?><br /><strong><?=$lot->getUser()?></strong><?=$lot->getUser() == $sf_user->getGuardUser()->getUsername() ? ' &mdash; это Вы!' : ''?></td>
                <td align="center" width="140"><span style="display:table-cell; background:<?=$lot->getUser() == $sf_user->getGuardUser()->getUsername() ? '#F70027' : '#74A600'?>;font-size:18px;color:#FFFFFF;white-space: nowrap;padding:5px 15px;"><strong id="lot_<?=$lot->getId()?>_price"><?=$lot->getPriceFormatted()?> руб.</strong></span></td>
                <td align="center"><strong class="strong"><?=$lot->getWinnerProfitPercentage()?>%</strong></td>
            </tr>

        <?php } ?>
    </table>

    <?php if ($pager->haveToPaginate()) { ?>

        <br clear="all" /><br />

        <div class="paging">

            <?php if ($pager->getPage() > 1) { ?>
                <?=link_to('предыдущая', '@user_auctions_list_my_status_page?status=closed&page=' . $pager->getPreviousPage())?>
            <?php } ?>

            <?php foreach ($pager->getLinks() as $page) { ?>

                <?php if ($page == $pager->getPage()) { ?>
                    <span><?=$page?></span>
                <?php } else { ?>
                    <?=link_to($page, '@user_auctions_list_my_status_page?status=closed&page=' . $page)?>
                <?php } ?>

            <?php } ?>

            <?php if ($pager->getLastPage() != $pager->getPage()) { ?>
                <?=link_to('следующая', '@user_auctions_list_my_status_page?status=closed&page=' . $pager->getNextPage())?>
            <?php } ?>

        </div>

    <?php } ?>

<?php } else { ?>

    <br clear="all" />Не найдено завершенных аукционов с Вашим участием.

<?php } ?>

</div>