<?php slot('page_title') ?>
    <?=$pageTitle?>
<?php end_slot(); ?>

<?php slot('breadcrumb') ?>
    <?php include_partial('global/breadcrumb', array('breadcrumb' => $breadcrumb)); ?>
<?php end_slot(); ?>

<?php slot('sidebar_left') ?>
    <?php include_partial('User/menu', array('menu' => sfConfig::get('app_menu_member'))); ?>
<?php end_slot(); ?>

<div id="list_tab">
    <span>Активные</span>
    <?=link_to('Завершенные', '@user_auctions_list_my_status?status=closed')?>
</div>

<div class="table_list_container">

<?php if ($pager->getNbResults()) { ?>

<script type="text/javascript">
    var userId = <?=$sf_user->isMember() ? $sf_user->getGuardUser()->getId(): '-1'?>;
    var betsRemaining = <?=$sf_user->isMember() ? $sf_user->getGuardUser()->getBalanceBets(): '-1'?>;

    $(document).ready(function () {
        if (null === lots.updaterTimer)
            lots.updater();
    });
</script>

<table cellpadding="0" cellspacing="0" width="100%" class="table_list">
    <tr bgcolor="#D9D9D9">
        <td colspan="2"><strong>Разыгрывается</strong></td>
        <td align="center"><strong>Стоимость</strong></td>
        <td align="center"><strong style="white-space: nowrap;">Последняя ставка</strong></td>
        <td align="center"><strong>Осталось</strong></td>
    </tr>

    <?php foreach ($pager->getResults() as $lot) { $product = sfCacheManager::getObject('Product', $lot->getProductId()); $betLast = sfCacheManager::getObject('Bet', $lot->getBetLastId()); ?>

        <script type="text/javascript">
            lots.price[<?=$lot->getId()?>] = '<?=$lot->getPriceFormatted()?>';
            lots.betLastUserId[<?=$lot->getId()?>] = '<?=$betLast && $betLast->getUserId() ? $betLast->getUserId() : 0?>';
        </script>

        <tr>
            <td style="border-bottom: none;" valign="top">
                <img src="/uploads/products/<?=$product->getImageIcon()?>" alt="" align="left" />
            </td>
            <td style="font-size:11px; border-bottom: none;">
                <a href="<?=url_for('Auction/view?lotId=' . $lot->getId())?>" class="a"><?=$product->getTitle()?></a><br /><br style="font-size:3px;" />
            </td>
            <td style="border-bottom: none;" align="center" width="150"><span style="display:table-cell; background:<?=$lot->getUser() == $sf_user->getGuardUser()->getUsername() ? '#F70027' : '#74A600'?>;font-size:18px;color:#FFFFFF;white-space: nowrap;padding:5px 15px;"><strong id="lot_<?=$lot->getId()?>_price"><?=$lot->getPriceFormatted()?> руб.</strong></span></td>
            <td style="border-bottom: none;" align="center"><strong id="lot_<?=$lot->getId()?>_author"><?=$lot->getUser()?></strong></td>
            <td align="center" width="150" rowspan="2">

                <div style="height: 30px;">
                    <?php if (!$lot->isClosedByTime()) { // Завершен ?>
                        <strong class="strong" id="lot_<?=$lot->getId()?>_time"><?=$lot->getTimeRemainingFormatted()?></strong>
                    <?php } else { ?>
                        <strong class="strong" id="lot_<?=$lot->getId()?>_time" style="color: #F70027;">Завершен</strong>
                    <?php } ?>
                    <br />
                </div>

                <?php if (!$lot->isClosedByTime()) { ?>

                    <br />
                    <table border="0" cellpadding="0" cellspacing="0" align="center" id="lot_<?=$lot->getId()?>_button">
                        <tr>
                            <td style="padding:0;border:0;">
                                <a href="#" onclick="lots.betAdd(<?=$lot->getId()?>); return false;" class="button_gray_12" onmouseover="button_gray_12_over(<?=$lot->getId()?>)" onmouseout="button_gray_12_out(<?=$lot->getId()?>)">
                                <table border="0" cellpadding="0" cellspacing="0"  style="display:inline;">
                                    <tr>
                                        <td class="button_gray_12_1" id="button_gray_12_<?=$lot->getId()?>_1" style="padding:0;border:0;"><img src="/images/spacer.gif" width="11" height="26" alt="" border="0" /></td>
                                        <td class="button_gray_12_2" id="button_gray_12_<?=$lot->getId()?>_2" style="padding:0;border:0;">Сделать ставку</td>
                                        <td class="button_gray_12_3" id="button_gray_12_<?=$lot->getId()?>_3" style="padding:0;border:0;"><img src="/images/spacer.gif" width="11" height="26" alt="" border="0" /></td>
                                    </tr>
                                </table>
                                </a>
                            </td>
                        </tr>
                    </table>

                <?php } ?>
            </td>
        </tr>
        <tr>
            <td colspan="4" style="padding-top: 0;">
                <?=$product->getDescriptionShort()?>
            </td>
        </tr>

    <?php } ?>

</table>

<?php } else { ?>

    <br clear="all" />Как же так? Вы пока не участвуете ни в одном активном аукционе!

<?php } ?>

</div>