<?php

/**
 * User actions.
 *
 * @package    auction
 * @subpackage User
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 12479 2008-10-31 10:54:40Z fabien $
 */
class UserActions extends sfActions
{
    public function executeIndex (sfWebRequest $request)
    {
        $this->forward('User', 'auctionsMy');
    }

    public function executeView (sfWebRequest $request)
    {
        $this->forward404Unless($request->hasParameter('userId'));

        $this->user = sfGuardUserPeer::retrieveByPK($request->getParameter('userId'));

        $this->forward404Unless($this->user);

        $cacheKey = 'PROFILE_USER_' . $this->user->getId() . '_AUCTIONS';
        if (!sfCacheManager::has($cacheKey)) {

            $c = new Criteria();
            $c->addJoin(LotPeer::ID, BetPeer::LOT_ID, Criteria::INNER_JOIN);
            $c->add(BetPeer::USER_ID, $this->user->getId());
            $c->addGroupByColumn(LotPeer::ID);
            $c->addDescendingOrderByColumn(LotPeer::DT_START);
            $c->setLimit(10);

            $this->auctions = LotPeer::doSelect($c);

            sfCacheManager::set($cacheKey, $this->auctions, array('LotList'));

        } else {

            $this->auctions = sfCacheManager::get($cacheKey);

        }

        $cacheKey = 'PROFILE_USER_' . $this->user->getId() . '_AUCTIONS_WON';
        if (!sfCacheManager::has($cacheKey)) {

            $c = new Criteria();
            $c->addJoin(LotPeer::BET_LAST_ID, BetPeer::ID, Criteria::INNER_JOIN);
            $c->add(BetPeer::USER_ID, $this->user->getId());
            $c->add(LotPeer::IS_CLOSED, true);
            $c->addGroupByColumn(LotPeer::ID);
            $c->addDescendingOrderByColumn(LotPeer::DT_END);

            $this->auctionsWon = LotPeer::doSelect($c);

            sfCacheManager::set($cacheKey, $this->auctionsWon, array('LotList'));

        } else {

            $this->auctionsWon = sfCacheManager::get($cacheKey);

        }

        $this->pageTitle = 'Профиль участника &mdash; ' . $this->user->getUsername();
        $this->breadcrumb = array(array($this->user->getUsername(), ''));
        $this->getResponse()->setTitle($this->user->getUsername() . ' &mdash; ' . sfConfig::get('app_meta_title'), false);
    }

    public function executeInfo (sfWebRequest $request)
    {
        $this->pageTitle = 'Личная информация';
        $this->breadcrumb = array(array('Мой кабинет', 'User/index'), array('Личная информация', ''));
        $this->getResponse()->setTitle('Личная информация' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);
    }

    public function executeEdit (sfWebRequest $request)
    {
        $this->pageTitle = 'Личная информация';
        $this->breadcrumb = array(array('Мой кабинет', 'User/index'), array('Личная информация', 'User/info'), array('Редактирование', ''));
        $this->getResponse()->setTitle('Редактирование личной информации' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $user = $this->getUser()->getGuardUser();

        $this->form = new sfGuardUserEditForm($user);

        if ($request->isMethod('post')) {
            $this->form->bind($request->getParameter('user'));
            if ($this->form->isValid()) {

                $userInfo = $this->form->getValues();

                if ($userInfo['password'])
                    $user->setPassword($userInfo['password']);

                $user->setName($userInfo['name']);
                $user->setEmail($userInfo['email']);

                $user->save();

                $this->redirect('User/info');

            }
        }
    }

    public function executeAvatar (sfWebRequest $request)
    {
        $this->pageTitle = 'Личная информация';
        $this->breadcrumb = array(array('Мой кабинет', 'User/index'), array('Личная информация', 'User/info'), array('Загрузка аватара', ''));
        $this->getResponse()->setTitle('Загрузка аватара' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $user = $this->getUser()->getGuardUser();

        $this->form = new AvatarForm();

        if ($request->isMethod('post')) {

            $this->form->bind($request->getParameter('avatar'), $request->getFiles('avatar'));

            if ($this->form->isValid()) {

                $file = $this->form->getValue('file');

                $filename = 'avatar_' . $user->getId() . $file->getOriginalExtension();
                @unlink(sfConfig::get('sf_upload_dir') . '/avatars/' . $filename);

                if (false !== strpos($filename, '.php'))
                    $this->redirect('@user_info');

                $file->save(sfConfig::get('sf_upload_dir') . '/avatars/' . $filename);

                $imageSize = sfCacheManager::getImageSize(sfConfig::get('sf_upload_dir') . '/avatars/' . $filename);

                $image = new sfImage(sfConfig::get('sf_upload_dir') . '/avatars/' . $filename, 'image/jpg');
                if ($imageSize[0] > 200) { // Выполняем уменьшение

                    $image->resize(200, null);
                    $image->save();

                }

                $user->setAvatar($filename);
                $user->save();

                $this->redirect('@user_info');

            }

        }
    }

    public function executeAvatarDelete (sfWebRequest $request)
    {
        $user = $this->getUser()->getGuardUser();

        if ($filename = $user->getAvatar()) {

            unlink(sfConfig::get('sf_upload_dir') . '/avatars/' . $filename);

            $user->setAvatar(null);
            $user->save();
        }

        $this->redirect('@user_info');
    }

    public function executeBetsAuto (sfWebRequest $request)
    {
        $this->pageTitle = 'Автоставки';
        $this->breadcrumb = array(array('Мой кабинет', 'User/index'), array('Текущие автоставки', ''));
        $this->getResponse()->setTitle('Автоставки' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $cacheKey = 'LOT_AUTOBETS_USER_' . $this->getUser()->getGuardUser()->getId();
        if (!sfCacheManager::has($cacheKey)) {

            $c = new Criteria();
            $c->add(LotAutobetPeer::USER_ID, $this->getUser()->getGuardUser()->getId());
            $c->addJoin(LotAutobetPeer::LOT_ID, LotPeer::ID, Criteria::INNER_JOIN);
            $c->add(LotPeer::IS_CLOSED, false);
            $c->addDescendingOrderByColumn(LotPeer::DT_START);

            $this->autobets = LotAutobetPeer::doSelect($c);

            sfCacheManager::set($cacheKey, $this->autobets, array('LotList', 'LotAutobetList'));

        } else {

            $this->autobets = sfCacheManager::get($cacheKey);

        }
    }

    public function executeBetsHistory (sfWebRequest $request)
    {
        $this->pageTitle = 'История ставок';
        $this->breadcrumb = array(array('Мой кабинет', 'User/index'), array('История ставок', ''));
        $this->getResponse()->setTitle('История ставок' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $c = new Criteria();
        $c->addJoin(BetPeer::LOT_ID, LotPeer::ID, Criteria::INNER_JOIN);
        $c->add(BetPeer::USER_ID, $this->getUser()->getGuardUser()->getId());
        $c->addDescendingOrderByColumn(BetPeer::DT_CREATED);

        $this->pager = new sfCachePager('Bet', 'BetList', 20);
        $this->pager->setCriteria($c);
        $this->pager->setPage($request->getParameter('page', 1));
        $this->pager->init();
    }

    public function executeAuctionsMy (sfWebRequest $request)
    {
        $this->pageTitle = 'Мои аукционы';
        $this->breadcrumb = array(array('Мой кабинет', 'User/index'), array('Мои аукционы', ''));
        $this->getResponse()->setTitle('Мои аукционы' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $c = new Criteria();
        $c->addJoin(LotPeer::ID, BetPeer::LOT_ID, Criteria::INNER_JOIN);
        $c->add(BetPeer::USER_ID, $this->getUser()->getGuardUser()->getId());
        $c->add(LotPeer::IS_CLOSED, false);
        $c->addGroupByColumn(LotPeer::ID);

        if ('closed' == $request->getParameter('status', 'active')) {

            $c->add(LotPeer::IS_CLOSED, true);
            $c->addDescendingOrderByColumn(LotPeer::DT_END);

        } else {

            $c->add(LotPeer::IS_CLOSED, false);
            $c->addAscendingOrderByColumn(LotPeer::DT_END);

        }

        $this->pager = new sfCachePager('Lot', 'LotList', 'active' == $request->getParameter('status', 'active') ? 100 : 10);
        $this->pager->setCriteria($c);
        $this->pager->setPage($request->getParameter('page', 1));
        $this->pager->init();

        return ucfirst($request->getParameter('status', 'active'));
    }

    public function executeAuctionsWon (sfWebRequest $request)
    {
        $this->pageTitle = 'Выигранные аукционы';
        $this->breadcrumb = array(array('Мой кабинет', 'User/index'), array('Выигранные аукционы', ''));
        $this->getResponse()->setTitle('Выигранные аукционы' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $c = new Criteria();
        $c->addJoin(LotPeer::BET_LAST_ID, BetPeer::ID, Criteria::INNER_JOIN);
        $c->add(BetPeer::USER_ID, $this->getUser()->getGuardUser()->getId());
        $c->add(LotPeer::IS_CLOSED, true);
        $c->addGroupByColumn(LotPeer::ID);

        $this->pager = new sfCachePager('Lot', 'LotList', 10);
        $this->pager->setCriteria($c);
        $this->pager->setPage($request->getParameter('page', 1));
        $this->pager->init();
    }

    public function executeAccount (sfWebRequest $request)
    {
        $this->pageTitle = 'Состояние счета';
        $this->breadcrumb = array(array('Мой кабинет', 'User/index'), array('Состояние счета', ''));
        $this->getResponse()->setTitle('Состояние счета' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        // Получаем пакеты ставок
        $c = new Criteria();
        $c->add(UserBetsPackagePeer::USER_ID, $this->getUser()->getGuardUser()->getId());
        $c->addDescendingOrderByColumn(UserBetsPackagePeer::DT_CREATED);

        $this->userBetsPackages = UserBetsPackagePeer::doSelect($c);

        // Получаем ваучеры
        $c = new Criteria();
        $c->add(UserVoucherPeer::USER_ID, $this->getUser()->getGuardUser()->getId());
        $c->addDescendingOrderByColumn(UserVoucherPeer::DT_CREATED);

        $this->userVouchers = UserVoucherPeer::doSelect($c);
    }

    public function executeAccountPay (sfWebRequest $request)
    {
        $this->pageTitle = 'Купить ставки';
        $this->breadcrumb = array(array('Мой кабинет', 'User/index'), array('Купить ставки', ''));
        $this->getResponse()->setTitle('Купить ставки' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $cacheKey = 'BETS_PACKAGES';
        if (!sfCacheManager::has($cacheKey)) {

            $c = new Criteria();
            $c->addAscendingOrderByColumn(BetsPackagePeer::BETS_COUNT);

            $this->packages = BetsPackagePeer::doSelect($c);

            sfCacheManager::set($cacheKey, $this->packages, array('BetsPackageList'), 30*24*3600); // 1 месяц

        } else {

            $this->packages = sfCacheManager::get($cacheKey);

        }
    }

//    public function executeAccountPayProcess (sfWebRequest $request)
//    {
//        $package = BetsPackagePeer::retrieveByPK($request->getParameter('packageId'));
//
//        $this->forward404Unless($package);
//        $this->forward404Unless($request->hasParameter('payTypeId'));
//
//        switch ($request->getParameter('payTypeId')) {
//            case sfConfig::get('app_pay_type_mobile_id'):
//                break;
//
//            case sfConfig::get('app_pay_type_card_id'):
//
//                $data = array(
//                    'wsb_seed'              => time(),
//                    'wsb_storeid'           => '631263677',
//                    'wsb_order_num'         => $package->getId() . '-' . rand(10000, 30000),
//                    'wsb_test'              => '0',
//                    'wsb_currency_id'       => 'BYR',
//                    'wsb_total'             => $package->getPrice(),
//                );
//
//                $signature = md5(implode('', $data) . sfConfig::get('app_pay_webpay_secret'));
//
//                $data += array(
//                    '*scart'                      => '',
//                    'wsb_signature'               => $signature,
//                    'wsb_store'                   => 'OBANA.BY',
//                    'wsb_return_url'              => $this->generateUrl('user_account_pay_complete', array(), true),
//                    'wsb_cancel_return_url'       => $this->generateUrl('user_account_pay_cancelled', array(), true),
//                    'wsb_notify_url'              => $this->generateUrl('user_account_pay_check_webpay', array(), true),
//                    'wsb_invoice_item_name[]'     => $package->getTitle(),
//                    'wsb_invoice_item_quantity[]' => 1,
//                    'wsb_invoice_item_price[]'    => $package->getPrice()
//                );
//
//                print $this->post('https://sandbox.webpay.by/', $data);
//                die();
//
//                break;
//        }
//
//        $this->redirect('User/accountPayComplete');
//    }

//    public function executeAccountPayCheckWebpay (sfWebRequest $request)
//    {
//        $paymentType = $request->getParameter(payment_type);
//
//        $signatureString =
//            $request->getParameter('batch_timestamp') .
//            $request->getParameter('currency_id') .
//            $request->getParameter('amount') .
//            $request->getParameter('payment_method') .
//            $request->getParameter('order_id') .
//            $request->getParameter('site_order_id') .
//            $request->getParameter('transaction_id') .
//            $request->getParameter('payment_type') .
//            $request->getParameter('rrn') .
//            sfConfig::get('app_webpay_secret');
//
//        // Проверка и зачисление на счет пакета
//        if ($request->getParameter('wsb_signature') == md5($signatureString) && (1 == $paymentType || 4 == $paymentType)) {
//
//            $packageId = current(explode('-', $this->getRequestParameter('site_order_id')));
//
//            $userBetsPackage = new UserBetsPackage();
//            $userBetsPackage->setUserId($this->getUser()->getGuardUser()->getId());
//            $userBetsPackage->setBetsPackageId($package->getId());
//            $userBetsPackage->setDtCreated(time());
//            $userBetsPackage->save();
//
//        }
//
//        return sfView::NONE;
//    }

    public function executeAccountPayCheckWebmoney (sfWebRequest $request)
    {
        if (!$request->hasParameter('userId') || !$request->hasParameter('packageId'))
            die('Ошибка! Переданы неверные параметры.');

        $user = sfGuardUserPeer::retrieveByPK($request->getParameter('userId'));
        $package = BetsPackagePeer::retrieveByPK($request->getParameter('packageId'));

        if (!$user || !$package)
            die('Ошибка! Переданы неверные параметры.');

		if ($request->getParameter('LMI_PREREQUEST')) {

            print 'YES';

        } else {

            $testString = $request->getParameter('LMI_PAYEE_PURSE') .
                          $request->getParameter('LMI_PAYMENT_AMOUNT') .
                          $request->getParameter('LMI_PAYMENT_NO') .
                          $request->getParameter('LMI_MODE') .
                          $request->getParameter('LMI_SYS_INVS_NO') .
                          $request->getParameter('LMI_SYS_TRANS_NO') .
                          $request->getParameter('LMI_SYS_TRANS_DATE') .
                          sfConfig::get('app_pay_webmoney_secret') .
                          $request->getParameter('LMI_PAYEE_PURSE') .
                          $request->getParameter('LMI_PAYER_WM');

            if (strtoupper(md5($testString)) != $request->getParameter('LMI_HASH'))
                die();

            // Создание платежа
            $payment = new Payment();
            $payment->setUserId($user->getId());
            $payment->setPaymentTypeId(sfConfig::get('app_pay_type_webmoney_id'));
            $payment->setBetsPackageId($package->getId());
            $payment->setStatus(sfConfig::get('app_pay_status_complete'));
            $payment->setDtCreated(time());
            $payment->setDescription($package->getTitle());
            $payment->save();

            print 'OK';

        }

        return sfView::NONE;
    }

    public function executeAccountPayWebmoney (sfWebRequest $request)
    {
        $errorText = 'Произошла ошибка. Не волнуйтесь, напишите нам по адресу <a href="mailto:aga@obana.by">aga@obana.by</a> с описанием проблемы, мы обязательно засчитаем Ваш пакет ставок.';

        function md5_upper($value)
        {
            return strtoupper(md5($value));
        }

        function strtoupper_ru($text)
        {
            $alfavitlover1 = array('ё','й','ц','у','к','е','н','г','ш','щ','з','х','ъ','ф','ы','в', 'а','п','р','о','л','д','ж','э', 'я','ч','с','м','и','т','ь','б','ю');
            $alfavitupper1 = array('Ё','Й','Ц','У','К','Е','Н','Г','Ш','Щ','З','Х','Ъ','Ф','Ы','В', 'А','П','Р','О','Л','Д','Ж','Э', 'Я','Ч','С','М','И','Т','Ь','Б','Ю');

            for($wr=0;$wr<=count($alfavitlover1);$wr++)
            {
                $alfavitupper[] = iconv('UTF-8', 'CP1251//IGNORE', $alfavitupper1[$wr]);
                $alfavitlover[] = iconv('UTF-8', 'CP1251//IGNORE', $alfavitlover1[$wr]);
            }

            $text = str_replace($alfavitlover, $alfavitupper, strtoupper($text));

            return $text;
        }

        $wmid          = $request->getParameter('WMID');
        $pci_wmtid     = $request->getParameter('pci_wmtid');
        $pci_pursedest = $request->getParameter('pci_pursedest');
        $pci_pursesrc  = $request->getParameter('pci_pursesrc');
        $pci_amount    = $request->getParameter('pci_amount');
        $pci_desc      = $request->getParameter('pci_desc');
        $pci_datecrt   = $request->getParameter('pci_datecrt');
        $pci_marker    = $request->getParameter('pci_marker');
        $pci_mode      = $request->getParameter('pci_mode');

        $userId = $request->getParameter('userId');
        $packageId = $request->getParameter('packageId');

        if (!$userId || !$packageId) {

            list($title, $userId, $packageId, $timestamp) = explode('_', $pci_desc);

            $sign = md5_upper($pci_wmtid . $wmid . md5_upper(strtoupper_ru('http://obana.by/profile/account/pay/webmoney' . sfConfig::get('app_pay_webmoney_purse') . $pci_amount . $pci_desc . $pci_mode)) . $pci_pursesrc . $pci_pursedest . $pci_amount . $pci_desc . $pci_datecrt . $pci_mode . md5_upper('atonechba'));

            file_put_contents('/var/www/trust/data/www/obana.by/web/uploads/info.txt', "$userId $packageId");

        } else {

            $sign = md5_upper($pci_wmtid . $wmid . md5_upper(strtoupper_ru('http://obana.by/profile/account/pay/webmoney?userId=' . $userId . '&packageId=' . $packageId . sfConfig::get('app_pay_webmoney_purse') . $pci_amount . $pci_desc . $pci_mode)) . $pci_pursesrc . $pci_pursedest . $pci_amount . $pci_desc . $pci_datecrt . $pci_mode . md5_upper('atonechba'));

        }

        if ($sign != $pci_marker)
            die($errorText);

        if (!$userId || !$packageId)
            die($errorText);

        $user = sfGuardUserPeer::retrieveByPK($userId);
        $package = BetsPackagePeer::retrieveByPK($packageId);

        if (!$user || !$package)
            die($errorText);

        if ($pci_amount != $package->getPrice()) // Проверка суммы
            die($errorText);

        if ($pci_pursedest != sfConfig::get('app_pay_webmoney_purse')) // Проверка кошелька продавца
            die($errorText);

        if ('text' == $pci_mode) // Проверка тестового режима
            die($errorText);

        // Создание платежа
        $payment = new Payment();
        $payment->setUserId($user->getId());
        $payment->setPaymentTypeId(sfConfig::get('app_pay_type_webmoney_id'));
        $payment->setBetsPackageId($package->getId());
        $payment->setStatus(sfConfig::get('app_pay_status_complete'));
        $payment->setDtCreated(time());
        $payment->setDescription($package->getTitle());
        $payment->save();

        if ($payment)
            die('Поздравляем! Пакет ставок успешно зачислен на счет.');
        else
            die($errorText);

        return sfView::NONE;
    }

    public function executeAccountPayCheckLiqpay (sfWebRequest $request)
    {
        $orderId = $request->getParameter('order_id');

        if (!$orderId)
            die('Ошибка! Переданы неверные параметры.');

        list ($userId, $packageId) = explode('-', $orderId);

        $user = sfGuardUserPeer::retrieveByPK($userId);
        $package = BetsPackagePeer::retrieveByPK($packageId);

        if (!$user || !$package)
            die('Ошибка! Переданы неверные параметры.');

        $signatureSource = '|' . $request->getParameter('version') .
                           '|' . sfConfig::get('app_pay_liqpay_password') .
                           '|' . $request->getParameter('action_name') .
                           '|' . $request->getParameter('sender_phone') .
                           '|' . $request->getParameter('merchant_id') .
                           '|' . $request->getParameter('amount') .
                           '|' . $request->getParameter('currency') .
                           '|' . $request->getParameter('order_id') .
                           '|' . $request->getParameter('transaction_id') .
                           '|' . $request->getParameter('status') .
                           '|' . $request->getParameter('code');

        $sign = base64_encode(sha1($signatureSource, 1));

        if (strtoupper(md5($testString)) != $request->getParameter('LMI_HASH'))
            die();

        $userBetsPackage = new UserBetsPackage();
        $userBetsPackage->setUserId($user->getId());
        $userBetsPackage->setBetsPackageId($package->getId());
        $userBetsPackage->setDtCreated(time());
        $userBetsPackage->save();

        print 'OK';

        return sfView::NONE;
    }

    public function executeAccountPayEasypay (sfWebRequest $request)
    {
        $this->pageTitle = 'Завершение платежа';
        $this->breadcrumb = array(array('Мой кабинет', 'User/index'), array('Купить ставки', 'User/accountPay'), array('Завершение платежа', ''));
        $this->getResponse()->setTitle('Завершение платежа' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $this->forward404Unless($request->hasParameter('packageId'));
        $this->forward404Unless($request->hasParameter('card'));

        $user = $this->getUser()->getGuardUser();
        $package = BetsPackagePeer::retrieveByPK($request->getParameter('packageId'));

        // Создание платежа
        $payment = new Payment();
        $payment->setUserId($user->getId());
        $payment->setPaymentTypeId(sfConfig::get('app_pay_type_easypay_id'));
        $payment->setBetsPackageId($package->getId());
        $payment->setStatus(sfConfig::get('app_pay_status_incomplete'));
        $payment->setDtCreated(time());
        $payment->setDescription($package->getTitle());
        $payment->save();

        // Формирование запроса
        $params = array(
            'mer_no'    => sfConfig::get('app_pay_easypay_mer_no'),   // тестовый ПТС
            'pass'      => sfConfig::get('app_pay_easypay_mer_pass'), // пароль на тестовый ПТС
            'order'     => $payment->getId(),                         // номер счета
            'sum'       => $package->getPrice(),                      // сумма в белорусских рублях
            'exp'       => '4',                                       // время жизни счета
            'card'      => $request->getParameter('card'),            // идентификатор электронного кошелька EasyPay
            'comment'   => iconv('utf-8', 'windows-1251', 'ОБАНА.BY - ' . $package->getTitle()) , // комментарий счета
            'info'      => iconv('utf-8', 'windows-1251', 'ОБАНА.BY - ' . $package->getTitle())   // информация о счете
        );

        $client = new SoapClient(sfConfig::get('app_pay_easypay_wsdl'),
            array(
                'trace'    => 1,
                'encoding' => 'windows-1251'
            )
        );

        try {

            $answer = $client->EP_CreateInvoice($params);

        } catch (SoapFault $fault) {

            $payment->delete();

            $this->pageTitle = 'Произошла ошибка!';

            return 'Error';

        }

        if (200 != (int) $answer->status->code) {

            $this->pageTitle = 'Произошла ошибка!';

            $payment->delete();

            return 'Error';

        }
    }

    public function executeAccountPaySms (sfWebRequest $request)
    {
        $this->pageTitle = 'Завершение платежа';
        $this->breadcrumb = array(array('Мой кабинет', 'User/index'), array('Купить ставки', 'User/accountPay'), array('Завершение платежа', ''));
        $this->getResponse()->setTitle('Завершение платежа' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $this->forward404Unless($request->hasParameter('packageId'));

        $user = $this->getUser()->getGuardUser();
        $package = BetsPackagePeer::retrieveByPK($request->getParameter('packageId'));

        $this->message = sfConfig::get('app_pay_sms_prefix') . $user->getId() . ($package->getId() < 10 ? '0' : '') . $package->getId();
    }

    public function executeAccountPayCheckSms (sfWebRequest $request)
    {
        if (!$request->hasParameter('smsarg'))
            die(iconv('utf-8', 'windows-1251', 'Произошла ошибка.'));

        if (sfConfig::get('app_pay_sms_login') != $request->getParameter('login') || sfConfig::get('app_pay_sms_password') != $request->getParameter('pass'))
            die(iconv('utf-8', 'windows-1251', 'Произошла ошибка.'));

        $message = $request->getParameter('smsarg');
        $message = trim($message);

        $userId = (int) substr($message, 0, strlen($message)-2);

        $user = sfGuardUserPeer::retrieveByPK($userId);

        if (!$user)
            die(iconv('utf-8', 'windows-1251', 'Произошла ошибка.'));

        $package = BetsPackagePeer::retrieveByPK(sfConfig::get('app_pay_sms_package_id'));

        if (!$package)
            die(iconv('utf-8', 'windows-1251', 'Произошла ошибка.'));

        // Создание платежа
        $payment = new Payment();
        $payment->setUserId($user->getId());
        $payment->setPaymentTypeId(sfConfig::get('app_pay_type_sms_id'));
        $payment->setBetsPackageId($package->getId());
        $payment->setStatus(sfConfig::get('app_pay_status_complete'));
        $payment->setDtCreated(time());
        $payment->setDescription($package->getTitle());
        $payment->save();

        die(iconv('utf-8', 'windows-1251', 'Спасибо! Пакет ставок успешно зачислен.'));
    }

    public function executeAccountPayComplete (sfWebRequest $request)
    {
        $this->pageTitle = 'Завершение платежа';
        $this->breadcrumb = array(array('Мой кабинет', 'User/index'), array('Купить ставки', 'User/accountPay'), array('Завершение платежа', ''));
        $this->getResponse()->setTitle('Завершение платежа' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $c = new Criteria();
        $c->add(UserBetsPackagePeer::USER_ID, $this->getUser()->getGuardUser()->getId());

        $this->betsPackagesCount = UserBetsPackagePeer::doCount($c);
    }

    public function executeLogin ($request)
    {
        $this->pageTitle = 'Авторизация';
        $this->breadcrumb = array(array('Авторизация', ''));
        $this->getResponse()->setTitle('Авторизация' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $user = $this->getUser();

        $class = sfConfig::get('app_sf_guard_plugin_signin_form', 'sfGuardFormSignin');
        $this->form = new $class();

        if ($request->isMethod('post') && 'Логин' != $request->getParameter('login[username]')) {
            $this->form->bind($request->getParameter('login'));

            if ($this->form->isValid()) {

                $values = $this->form->getValues();
                $this->getUser()->signin($values['user'], true);

                $redirectUrl = $request->getReferer();
                if (!$redirectUrl || false !== strpos($redirectUrl, '/login') || false !== strpos($redirectUrl, '/registration'))
                    $redirectUrl = '@homepage';

                return $this->redirect($redirectUrl);

            }
        }
    }

    public function executeLogout ($request)
    {
        $this->getUser()->signOut();

        $this->redirect('@homepage');
    }

    public function executeRegistration ($request)
    {
        $this->pageTitle = 'Регистрация';
        $this->breadcrumb = array(array('Регистрация', ''));
        $this->getResponse()->setTitle('Регистрация' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $this->form = new sfGuardUserForm();

        if ($request->isMethod('post')) {
            $this->form->bind($request->getParameter('user'));
            if ($this->form->isValid()) {

                $userInfo = $this->form->getValues();

                // Создание sfGuardUser
                $user = new sfGuardUser();
                $user->setUsername($userInfo['username']);
                $user->setPassword($userInfo['password']);
                $user->setName($userInfo['name']);
                $user->setEmail($userInfo['email']);
                $user->setPhone($userInfo['phone']);

                if ($this->getUser()->hasAttribute('user_partner_id')) {

                    $userPartner = sfGuardUserPeer::retrieveByPK($this->getUser()->getAttribute('user_partner_id'));

                    if ($userPartner)
                        $user->setUserPartnerId($userPartner->getId());

                    $this->getUser()->setAttribute('user_partner_id', 0);

                }

                $user->setIsActive(0);

                $user->save();

                // Обработка промо-кода
                $c = new Criteria();
                $c->add(PromoCodePeer::CODE, strtolower($userInfo['promo_code']));

                $promoCode = PromoCodePeer::doSelectOne($c);

                if (!$promoCode)
                    $promoCode = PromoCodePeer::retrieveByPK(sfConfig::get('app_promo_code_default_id'));

                if ($promoCode) {

                    $userPromoCode = new UserPromoCode();
                    $userPromoCode->setUserId($user->getId());
                    $userPromoCode->setPromoCodeId($promoCode->getId());
                    $userPromoCode->save();

                    $betsPackages = $promoCode->getPromoCodeBetsPackages();
                    $vouchers = $promoCode->getPromoCodeVouchers();

                    if ($betsPackages)
                        foreach ($betsPackages as $betsPackage) {

                            $userBetsPackage = new UserBetsPackage();
                            $userBetsPackage->setUserId($user->getId());
                            $userBetsPackage->setBetsPackageId($betsPackage->getBetsPackageId());
                            $userBetsPackage->setDtCreated(time());
                            $userBetsPackage->save();

                        }

                    if ($vouchers)
                        foreach ($vouchers as $voucher) {

                            $userVoucher = new UserVoucher();
                            $userVoucher->setUserId($user->getId());
                            $userVoucher->setVoucherId($voucher->getId());
                            $userVoucher->setDtCreated(time());
                            $userVoucher->save();

                        }
                }

                // Создание sfGuardUserGroup
    //            $userGroup = new sfGuardUserGroup();
    //            $userGroup->setUserId($user->getId());
    //            $userGroup->setGroupId(sfConfig::get('app_user_group_member'));
    //            $userGroup->save();

                // Авторизация
                $this->getUser()->signIn($user, false);

                // Отсылаем уведомление
                $request->setAttribute('user_id', $user->getId());
                $request->setAttribute('password', $userInfo['password']);
                $this->emailRegistrationConfirmation();

                $this->redirect('User/registrationComplete');

            }
        }
    }

    public function executeRegistrationComplete ($request)
    {
        $this->pageTitle = 'Завершение регистрации';
        $this->breadcrumb = array(array('Регистрация', 'User/registration'), array('Завершение', ''));
        $this->getResponse()->setTitle('Завершение регистрации' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);
    }

    public function executeRegistrationConfirm ($request)
    {
        $this->pageTitle = 'Завершение регистрации';
        $this->breadcrumb = array(array('Регистрация', 'User/registration'), array('Завершение', ''));
        $this->getResponse()->setTitle('Завершение регистрации' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $this->forward404Unless($request->hasParameter('login'));
        $this->forward404Unless($request->hasParameter('code'));

        $c = new Criteria();
        $c->add(sfGuardUserPeer::USERNAME, $request->getParameter('login'));
        $user = sfGuardUserPeer::doSelectOne($c);

        $this->forward404Unless($user);

        $this->forward404Unless(substr(md5(sfConfig::get('app_confirmation_salt') . 'registration' . $user->getEmail()), 0, 10) == $request->getParameter('code'));

        $user->setIsActive(true);
        $user->save();
    }

    public function executeRestore ($request)
    {
        $this->pageTitle = 'Восстановление пароля';
        $this->breadcrumb = array(array('Восстановление пароля', ''));
        $this->getResponse()->setTitle('Восстановление пароля' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        if ($request->isMethod('post')) {

            $this->forward404Unless($request->hasParameter('restore'));
            $restoreInfo = $request->getParameter('restore');
            $this->forward404Unless(array_key_exists('email', $restoreInfo));

            $c = new Criteria();
            $c->add(sfGuardUserPeer::EMAIL, $restoreInfo['email']);

            $user = sfGuardUserPeer::doSelectOne($c);

            if ($user) {

                $this->getRequest()->setAttribute('user_id', $user->getId());
                $this->emailRestoreConfirmation();

                return 'Complete';

            } else {

                $this->error = 'Нет пользователей, зарегистрированных с таким E-Mail.';

            }

        }
    }

    public function executeRestoreConfirm ($request)
    {
        $this->pageTitle = 'Восстановление пароля';
        $this->breadcrumb = array(array('Восстановление пароля', ''));
        $this->getResponse()->setTitle('Восстановление пароля' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $this->forward404Unless($request->hasParameter('login'));
        $this->forward404Unless($request->hasParameter('code'));

        $c = new Criteria();
        $c->add(sfGuardUserPeer::USERNAME, $request->getParameter('login'));
        $user = sfGuardUserPeer::doSelectOne($c);

        $this->forward404Unless($user);

        $this->forward404Unless(substr(md5(sfConfig::get('app_confirmation_salt') . 'restore' . $user->getEmail()), 0, 10) == $request->getParameter('code'));

        $this->form = new sfGuardUserEditForm();
        $this->form->getValidator('password')->setOption('required', true);
        $this->form->getValidator('email')->setOption('required', false);

        if ($request->isMethod('post')) {
            $this->form->bind($request->getParameter('user'));
            if ($this->form->isValid()) {

                $userInfo = $this->form->getValues();

                if ($userInfo['password'])
                    $user->setPassword($userInfo['password']);

                $user->save();

                return 'Complete';

            }
        }
    }

    public function executeFeedback (sfWebRequest $request)
    {
        $this->pageTitle = 'Обратная связь';
        $this->breadcrumb = array(array('Обратная связь', ''));
        $this->getResponse()->setTitle('Обратная связь' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $this->form = new MailForm();

        if ($this->getUser()->isMember())
            $this->form->setDefault('email', $this->getUser()->getGuardUser()->getEmail());

        if ($request->isMethod('post')) {

            $this->form->bind($request->getParameter('mail'));

            if ($this->form->isValid()) {

                $mailInfo = $this->form->getValues();

                $mail = new Mail();

                if ($this->getUser()->isMember())
                    $mail->setUserFromId($this->getUser()->getGuardUser()->getId());

                $mail->setUserToId(sfConfig::get('app_mail_admin_id'));
                $mail->setEmail($mailInfo['email']);
                $mail->setSubject($mailInfo['subject']);
                $mail->setMessage($mailInfo['message']);
                $mail->setDtCreated(time());
                $mail->save();

                // Отсылаем уведомление
                $request->setAttribute('mail', $mail);
                $this->emailFeedback();

                $this->redirect('User/feedbackComplete');

            }

        }
    }

    public function executeMail (sfWebRequest $request)
    {
        $this->pageTitle = 'Сообщения';
        $this->breadcrumb = array(array('Сообщения', ''));
        $this->getResponse()->setTitle('Сообщения' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $c = new Criteria();

        if ('inbox' == $request->getParameter('folder', 'inbox'))

            $c->add(MailPeer::USER_TO_ID, $this->getUser()->getGuardUser()->getId());

        else if ('sent' == $request->getParameter('folder', 'inbox'))

            $c->add(MailPeer::USER_FROM_ID, $this->getUser()->getGuardUser()->getId());

        else if ('all' == $request->getParameter('folder', 'inbox')) {

            $criterion = $c->getNewCriterion(MailPeer::USER_TO_ID, $this->getUser()->getGuardUser()->getId());
            $criterion->addOr( $c->getNewCriterion(MailPeer::USER_FROM_ID, $this->getUser()->getGuardUser()->getId()));

            $c->add($criterion);
        } else {

            $this->forward404();

        }

        $c->addDescendingOrderByColumn(MailPeer::DT_CREATED);

        $this->pager = new sfCachePager('Mail', 'MailList', 15);
        $this->pager->setCriteria($c);
        $this->pager->setPage($request->getParameter('page', 1));
        $this->pager->init();
    }

    public function executeMailCreate (sfWebRequest $request)
    {
        $this->pageTitle = 'Новое сообщение';
        $this->breadcrumb = array(array('Сообщения', '@user_mail'), array('Новое сообщение', ''));
        $this->getResponse()->setTitle('Новое сообщение' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $this->form = new MailForm(null, array('url' => $this->getController()->genUrl('User/ajaxUserlist')));
        $this->form->getValidator('user_to_id')->setOption('required', true);
        $this->form->getValidator('email')->setOption('required', false);

        if ($request->isMethod('post')) {

            $this->form->bind($request->getParameter('mail'));

            if ($this->form->isValid()) {

                $mailInfo = $this->form->getValues();

                $mail = new Mail();

                if ($this->getUser()->isMember())
                    $mail->setUserFromId($this->getUser()->getGuardUser()->getId());

                $mail->setUserToId($mailInfo['user_to_id']);
                $mail->setEmail($mailInfo['email']);
                $mail->setSubject($mailInfo['subject']);
                $mail->setMessage($mailInfo['message']);
                $mail->setDtCreated(time());
                $mail->save();

                // Отсылаем уведомление
                $request->setAttribute('mail', $mail);
                $this->emailFeedback();

                $this->redirect('@user_mail');

            }

        }
    }

    public function executeMailRead (sfWebRequest $request)
    {
        $this->forward404Unless($request->hasParameter('mailId'));

        $mail = MailPeer::retrieveByPK($request->getParameter('mailId'));

        $this->forward404Unless($mail);

        $mail->setIsRead(true);
        $mail->save();

        return sfView::NONE;
    }

    public function executeAjaxUserlist(sfWebRequest $request)
    {
        $this->getResponse()->setContentType('application/json');

        $c = new Criteria();
        $c->add(sfGuardUserPeer::USERNAME, $request->getParameter('q') . '%', Criteria::LIKE);
        $c->addAscendingOrderByColumn(sfGuardUserPeer::USERNAME);
        $c->setLimit(10);

        $users = sfGuardUserPeer::doSelect($c);

        $usernames = array();
        foreach ($users as $user)
            $usernames[$user->getId()] = $user->getUsername();

        return $this->renderText(json_encode($usernames));
    }

    public function executeMailSend (sfWebRequest $request)
    {
        $this->form = new MailForm();

        if ($request->isMethod('post')) {

            $this->form->bind($request->getParameter('mail'));

            if ($this->form->isValid()) {

                $mailInfo = $this->form->getValues();

                $mail = new Mail();

                if ($this->getUser()->isMember())
                    $mail->setUserFromId($this->getUser()->getGuardUser()->getId());

                $mail->setUserToId($mailInfo['user_to_id']);
                $mail->setEmail($mailInfo['email']);
                $mail->setSubject($mailInfo['subject']);
                $mail->setMessage($mailInfo['message']);
                $mail->setDtCreated(time());
                $mail->save();

                // Отсылаем уведомление
                $request->setAttribute('mail', $mail);
                $this->emailFeedback();

            }

        }

        $this->redirect('@user_mail');
    }

    public function executeFeedbackComplete (sfWebRequest $request)
    {
        $this->pageTitle = 'Обратная связь';
        $this->breadcrumb = array(array('Обратная связь', 'User/feedback'), array('Сообщение отправлено', ''));
        $this->getResponse()->setTitle('Обратная связь' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);
    }

    private function emailFeedback ()
    {
        $mail = $this->getRequest()->getAttribute('mail');

        if (!$mail)
            return false;

        $userTo = $mail->getsfGuardUserRelatedByUserToId();

        if ($userTo) {
            $mailTo = $userTo->getEmail();
            $mailFrom = $mail->getEmail();
            $mailSubject = 'Аукционы OBANA.BY | Отзыв | ' . $mail->getSubject();
            $mailBody = $mail->getMessage();
            $mailBody = $this->getPartial('User/emailMail', array(
                'mail'     => $mail,
                'userFrom' => $mail->getsfGuardUserRelatedByUserFromId()
            ));

            $this->getUser()->sendEmail($mailFrom, $mailTo, $mailSubject, $mailBody);
        }
    }

    private function emailRegistrationConfirmation ()
    {
        $user = sfGuardUserPeer::retrieveByPK($this->getRequest()->getAttribute('user_id'));

        if (!$user)
            return false;

        $mailTo = $user->getEmail();
        $mailFrom = new Swift_Address('aga@obana.by', 'ОБАНА.BY');
        $mailSubject = 'Аукционы OBANA.BY | Подтверждение регистрации';
        $mailBody = $this->getPartial('User/emailRegistrationConfirmation', array(
            'code' => substr(md5(sfConfig::get('app_confirmation_salt') . 'registration' . $user->getEmail()), 0, 10),
            'login' => $user->getUsername(),
            'password' => $this->getRequest()->getAttribute('password')
        ));

        $this->getUser()->sendEmail($mailFrom, $mailTo, $mailSubject, $mailBody);
    }

    private function emailRestoreConfirmation ()
    {
        $user = sfGuardUserPeer::retrieveByPK($this->getRequest()->getAttribute('user_id'));

        if (!$user)
            return sfView::NONE;

        $mailTo = $user->getEmail();
        $mailFrom = new Swift_Address('aga@obana.by', 'ОБАНА.BY');
        $mailSubject = 'Аукционы OBANA.BY | Восставновление пароля';
        $mailBody = $this->getPartial('User/emailRestoreConfirmation', array(
            'code' => substr(md5(sfConfig::get('app_confirmation_salt') . 'restore' . $user->getEmail()), 0, 10),
            'login' => $user->getUsername(),
            'password' => $this->getRequest()->getAttribute('password')
        ));

        $this->getUser()->sendEmail($mailFrom, $mailTo, $mailSubject, $mailBody);
    }

}
