<?php slot('page_title') ?>
    <?=$pageTitle?>
<?php end_slot(); ?>

<?php slot('breadcrumb') ?>
    <?php include_partial('global/breadcrumb', array('breadcrumb' => $breadcrumb)); ?>
<?php end_slot(); ?>

Итак, &laquo;Рейтинг&raquo; представляет собой показатель
активности каждого участника проекта. Чем выше рейтинг &mdash; тем активнее ведет себя участник, и наоборот.
Каждую неделю, в 23:59 воскресенья мы будем определять победителей &mdash; тройку наиболее "рейтинговых" участников.
<strong>Они получат соответственно по 100, 50 и 20 ставок бесплатно!</strong>

<br /><br />

Как же вычисляется рейтинг? Просто &mdash; используется широко известная Супер Формула Админа (СФА). Во избежание
накрутки мы не будем описывать детали её вычисления, кроме того, будем постоянно усложнять её, с той же целью.

<br /><br />

<div id="list_tab" style="width: 100%;">
<?php if ('week' == $type) { ?>
    <span>Неделя</span>
<?php } else { ?>
    <?=link_to('Неделя', '@rating_index_type?type=week')?>
<?php } ?>

<?php if ('overall' == $type) { ?>
    <span>Общий</span>
<?php } else { ?>
    <?=link_to('Общий', '@rating_index_type?type=overall')?>
<?php } ?>
</div>

<?php if ($pager->getNbResults()) { ?>

    <div class="table_list_container">

    <table cellpadding="0" cellspacing="0" width="100%" class="table_list">
        <tr bgcolor="#D9D9D9">
            <td><strong>Участник</strong></td>
            <td><strong>Дата регистрации</strong></td>
            <td align="center"><strong>Рейтинг &mdash; неделя</strong></td>
            <td align="center"><strong>Рейтинг &mdash; общий</strong></td>
        </tr>

        <?php $odd = false; foreach ($pager->getResults() as $user) { $odd = !$odd; ?>

            <tr<?=$odd ? ' bgcolor="#F5F5F5"' : ''?>>
                <td width="400"><a onmouseover="$(this).find('img').attr('src', '/images/info_sm_over.png');" onmouseout="$(this).find('img').attr('src', '/images/info_sm.png');" href="<?=url_for('@user_view?userId=' . $user->getId())?>" title="Профиль участника"><img src="/images/info_sm.png" width="13" height="13" style="vertical-align: middle;" alt="Профиль участника" /></a> &nbsp;<strong style="vertical-align: middle;"><?=$user->getUsername()?></strong><?=($sf_user->isMember() && $sf_user->getGuardUser()->getId() == $user->getId()) ? ' &mdash; это Вы' : ''?></td>
                <td><?=$user->getCreatedAtFormatted()?></td>
                <td align="center">
                    <?php if ('week' == $type) { ?><strong><?php } ?>
                    <?=$user->getRatingWeekFormatted()?>
                    <?php if ('week' == $type) { ?></strong><?php } ?>
                </td>
                <td align="center">
                    <?php if ('overall' == $type) { ?><strong><?php } ?>
                    <?=$user->getRatingFormatted()?>
                    <?php if ('overall' == $type) { ?></strong><?php } ?>
                </td>
            </tr>

        <?php } ?>

    </table>

    </div>

    <?php if ($pager->haveToPaginate()) { ?>

        <br clear="all" /><br />

        <div class="paging">

            <?php if ($pager->getPage() > 1) { ?>
                <?=link_to('предыдущая', '@rating_index_type_page?type=' . $type . '&page=' . $pager->getPreviousPage())?>
            <?php } ?>

            <?php foreach ($pager->getLinks() as $page) { ?>

                <?php if ($page == $pager->getPage()) { ?>
                    <span><?=$page?></span>
                <?php } else { ?>
                    <?=link_to($page, '@rating_index_type_page?type=' . $type . '&page=' . $page)?>
                <?php } ?>

            <?php } ?>

            <?php if ($pager->getLastPage() != $pager->getPage()) { ?>
                <?=link_to('следующая', '@rating_index_type_page?type=' . $type . '&page=' . $pager->getNextPage())?>
            <?php } ?>

        </div>

    <?php } ?>

<?php } else { ?>

    Удивительно, но список пользователей пуст.

<?php } ?>