<?php

/**
 * Rating actions.
 *
 * @package    auction
 * @subpackage Rating
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 12479 2008-10-31 10:54:40Z fabien $
 */
class RatingActions extends sfActions
{
    public function executeIndex(sfWebRequest $request)
    {
        $this->forward404Unless(!$request->hasParameter('type') || 'week' == $request->getParameter('type') || 'overall' == $request->getParameter('type'));

        $this->type = $request->getParameter('type', 'week');

        $this->pageTitle = 'Рейтинг &mdash; ' . ('week' == $this->type ? 'текущая неделя' : 'за все время');
        $this->breadcrumb = array(array('Рейтинг', '@rating_index'), array('week' == $this->type ? 'Текущая неделя' : 'За все время', ''));
        $this->getResponse()->setTitle('Рейтинг &mdash; ' . ('week' == $this->type ? 'текущая неделя' : 'за все время') . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $c = new Criteria();

        if (1 == date('N') || 'overall' == $this->type) {

            $c->addDescendingOrderByColumn(sfGuardUserPeer::RATING);

        } else {

            $c->addDescendingOrderByColumn(sfGuardUserPeer::RATING_WEEK);

        }

        $c->addAscendingOrderByColumn(sfGuardUserPeer::USERNAME);

        $this->pager = new sfCachePager('sfGuardUser', 'sfGuardUserList', 20);
        $this->pager->setCriteria($c);
        $this->pager->setPage($request->getParameter('page', 1));
        $this->pager->init();
    }
}
