<?php slot('page_title') ?>
    <?=$pageTitle?>
<?php end_slot(); ?>

<?php slot('breadcrumb') ?>
    <?php include_partial('global/breadcrumb', array('breadcrumb' => $breadcrumb)); ?>
<?php end_slot(); ?>

<?php slot('sidebar_left') ?>
    <?php include_partial('User/menu', array('menu' => sfConfig::get('app_menu_member'))); ?>
<?php end_slot(); ?>

<?php if ($pager->getNbResults()) { ?>

    <div class="table_list_container">

        <table cellpadding="0" cellspacing="0" width="100%" class="table_list">
            <tr bgcolor="#D9D9D9">
                <td width="400"><strong>Дата</strong></td>
                <td align="center"><strong>Количество ставок</strong></td>
            </tr>

            <?php $odd = false; foreach ($pager->getResults() as $partnerPayment) { ?>

                <tr<?=$odd ? ' bgcolor="#F5F5F5"' : ''?>>
                    <td width="400"><?=$partnerPayment->getDtFormatted()?></td>
                    <td align="center"><?=$partnerPayment->getAmountBets()?></td>
                </tr>

            <?php } ?>

        </table>

    </div>

    <?php if ($pager->haveToPaginate()) { ?>

        <br clear="all" /><br />

        <div class="paging">

            <?php if ($pager->getPage() > 1) { ?>
                <?=link_to('предыдущая', '@user_partner_report_page?page=' . $pager->getPreviousPage())?>
            <?php } ?>

            <?php foreach ($pager->getLinks() as $page) { ?>

                <?php if ($page == $pager->getPage()) { ?>
                    <span><?=$page?></span>
                <?php } else { ?>
                    <?=link_to($page, '@user_partner_report_page?page=' . $page)?>
                <?php } ?>

            <?php } ?>

            <?php if ($pager->getLastPage() != $pager->getPage()) { ?>
                <?=link_to('следующая', '@user_partner_report_page?page=' . $pager->getNextPage())?>
            <?php } ?>

        </div>

    <?php } ?>

<?php } else { ?>

    Ваши друзья пока не принесли Вам ставок.

<?php } ?>