<?php

/**
 * Partner actions.
 *
 * @package    auction
 * @subpackage Partner
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 12479 2008-10-31 10:54:40Z fabien $
 */
class PartnerActions extends sfActions
{
    public function executeInfo (sfWebRequest $request)
    {
        $this->pageTitle = 'Ссылки и баннеры';
        $this->breadcrumb = array(array('Мой кабинет', 'User/index'), array('Ссылки и баннеры', ''));
        $this->getResponse()->setTitle('Ссылки и баннеры' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

    }

    public function executeFriendsList (sfWebRequest $request)
    {
        $this->pageTitle = 'Приглашенные пользователи';
        $this->breadcrumb = array(array('Мой кабинет', 'User/index'), array('Приглашенные пользователи', ''));
        $this->getResponse()->setTitle('Приглашенные пользователи' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $c = new Criteria();
        $c->add(sfGuardUserPeer::USER_PARTNER_ID, $this->getUser()->getGuardUser()->getId());
        $c->addDescendingOrderByColumn(sfGuardUserPeer::CREATED_AT);

        $this->pager = new sfCachePager('sfGuardUser', 'sfGuardUserList', 20);
        $this->pager->setCriteria($c);
        $this->pager->setPage($request->getParameter('page', 1));
        $this->pager->init();
    }

    public function executeReport (sfWebRequest $request)
    {
        $this->pageTitle = 'Партнерский отчет';
        $this->breadcrumb = array(array('Мой кабинет', 'User/index'), array('Партнерский отчет', ''));
        $this->getResponse()->setTitle('Партнерский отчет' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $c = new Criteria();
        $c->add(PartnerPaymentPeer::USER_ID, $this->getUser()->getGuardUser()->getId());
        $c->addDescendingOrderByColumn(PartnerPaymentPeer::DT);

        $this->pager = new sfCachePager('PartnerPayment', 'PartnerPaymentList', 20);
        $this->pager->setCriteria($c);
        $this->pager->setPage($request->getParameter('page', 1));
        $this->pager->init();
    }

    public function executeSetPartner (sfWebRequest $request)
    {
        $this->forward404unless($request->hasParameter('userId'));

        $this->getUser()->setAttribute('user_partner_id', $request->getParameter('userId'));

        $this->redirect('@homepage');
    }
}
