<?php

/**
 * Page actions.
 *
 * @package    auction
 * @subpackage Page
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 12479 2008-10-31 10:54:40Z fabien $
 */
class PageActions extends sfActions
{
    public function executeShow (sfWebRequest $request)
    {
        $slug = $request->hasParameter('slug') ? $request->getParameter('slug') : substr($_SERVER['REQUEST_URI'], 1);

        $c = new Criteria();
        $c->add(PagePeer::SLUG, $slug);
        $this->page = PagePeer::doSelectOne($c);

        $this->redirectUnless($this->page, '/404');

        $this->pageTitle = $this->page->getTitle();
        $this->breadcrumb = array(array($this->page->getTitle(), ''));
        $this->getResponse()->setTitle($this->page->getTitle() . ' &mdash; ' . sfConfig::get('app_meta_title'), false);
    }

    public function execute404 (sfWebRequest $request)
    {
        $this->getRequest()->setParameter('slug', '404');
        $this->forward('Page', 'show');
    }

    public function execute403 (sfWebRequest $request)
    {
        $this->getRequest()->setParameter('slug', '403');
        $this->forward('Page', 'show');
    }
}
