<?php

class NewsComponents extends sfActions
{
    public function executeLastNews (sfWebRequest $request)
    {
        $cacheKey = 'NEWS_LAST';
        if (!sfCacheManager::has($cacheKey)) {

            $c = new Criteria();
            $c->add(NewsPeer::IS_ACTIVE, true);
            $c->addDescendingOrderByColumn(NewsPeer::DT_CREATED);
            $c->setLimit(1);

            $this->news = NewsPeer::doSelectOne($c);

            sfCacheManager::set($cacheKey, $this->news, array('NewsList'));

        } else {

            $this->news = sfCacheManager::get($cacheKey);

        }
    }
}