<?php

class ChatComponents extends sfActions
{
    public function executeShow (sfWebRequest $request)
    {
        $cacheKey = 'CHAT_LIST_LAST_10';
        if (!sfCacheManager::has($cacheKey)) {

            $c = new Criteria();
            $c->add(ChatPeer::DT_CREATED, 'UNIX_TIMESTAMP(' . ChatPeer::DT_CREATED . ') >= ' . (time() - 60*60), Criteria::CUSTOM); // Сообщения не старше 1 часа
            $c->addDescendingOrderByColumn(ChatPeer::DT_CREATED);
            $c->setLimit(10);

            $this->items = array_reverse(ChatPeer::doSelect($c));

            sfCacheManager::set($cacheKey, $this->items, array('ChatList'));

        } else {

            $this->items = sfCacheManager::get($cacheKey);

        }
    }
}