<?php slot('page_title') ?>
    <?=$pageTitle?>
<?php end_slot(); ?>

<?php slot('breadcrumb') ?>
    <?php include_partial('global/breadcrumb', array('breadcrumb' => $breadcrumb)); ?>
<?php end_slot(); ?>

<div id="list_tab">
    <?php if ('active' == $sf_request->getParameter('status', 'active')) { ?>
        <span>Активные</span>
    <?php } else { ?>
        <?=link_to('Активные', '@auction_list')?>
    <?php } ?>

    <?php if ('closed' == $sf_request->getParameter('status', 'active')) { ?>
        <span>Завершенные</span>
    <?php } else { ?>
        <?=link_to('Завершенные', '@auction_list_status?status=closed')?>
    <?php } ?>
</div>

<div class="table_list_container">

<table border="0" cellpadding="0" cellspacing="0" width="100%" class="table_list">
    <tr bgcolor="#D9D9D9">
        <td><strong>Наименование</strong></td>
        <td align="center"><strong>Завершен</strong></td>
        <td align="center"><strong>Победитель</strong></td>
        <td align="center"><strong>Стоимость</strong></td>
        <td align="center"><strong>Экономия</strong></td>
    </tr>

    <?php foreach ($pager->getResults() as $lot) { $product = sfCacheManager::getObject('Product', $lot->getProductId()); $betLast = sfCacheManager::getObject('Bet', $lot->getBetLastId()); ?>

        <tr>
            <td style="font-size:11px;">

                <?php if ($lot->isOptionManual()) { ?>
                    <div class="sticker_list">
                        <a href="/help/14" title="Только ручные ставки"><img src="/images/option/manual.png" width="44" height="42" alt="Только ручные ставки" /></a>
                    </div>
                <?php } ?>

                <?php if ($lot->isOptionNovice()) { ?>
                    <div class="sticker_list">
                        <a href="/help/14" title="Только для новичков"><img src="/images/option/novice.png" width="44" height="42" alt="Только для новичков" /></a>
                    </div>
                <?php } ?>

                <?php if ($lot->isOptionCompensation()) { ?>
                    <div class="sticker_list">
                        <a href="/help/14" title="Аукцион с компенсацией"><img src="/images/option/compensation.png" width="44" height="42" alt="Аукцион с компенсацией" /></a>
                    </div>
                <?php } ?>

                <a href="<?=url_for('Auction/view?lotId=' . $lot->getId())?>" class="a"><img src="/uploads/products/<?=$product->getImageMainThumb()?>" width="90" height="90" alt="" align="left" style="margin:0 15px 15px 0;" /></a>
                <a href="<?=url_for('Auction/view?lotId=' . $lot->getId())?>" class="a"><?=$product->getTitle()?></a><br /><br style="font-size:3px;" />
                <?=$product->getDescriptionShort()?>
            </td>
            <td align="center" width="120"><?=$lot->getDtEndFormatted()?></td>
            <td align="center"><strong id="lot_<?=$lot->getId()?>_author"><?=$lot->getUser() ? $lot->getUser() . ' <a onmouseover="$(this).find(\'img\').attr(\'src\', \'/images/info_sm_over.png\');" onmouseout="$(this).find(\'img\').attr(\'src\', \'/images/info_sm.png\');" id="lot_' . $lot->getId() . '_author_url" href="' . url_for('@user_view?userId=' . $betLast->getUserId()) . '" title="Профиль участника"><img src="/images/info_sm.png" width="13" height="13" style="margin-bottom: -2px;" alt="Профиль участника" /></a>' : '&nbsp;'?></strong></td>
            <td align="center" width="140"><span style="display:table-cell; background:<?=$sf_user->isMember() && $lot->getUser() == $sf_user->getGuardUser()->getUsername() ? '#F70027' : '#74A600'?>;font-size:18px;color:#FFFFFF;white-space: nowrap;padding:5px 15px;"><strong id="lot_<?=$lot->getId()?>_price"><?=$lot->getPriceFormatted()?> руб.</strong></span></td>
            <td align="center"><strong class="strong"><?=$lot->getWinnerProfitPercentage()?>%</strong></td>
        </tr>

    <?php } ?>

</table>

</div>

<?php if ($pager->haveToPaginate()) { ?>

    <br clear="all" /><br />

    <div class="paging">

        <?php if ($pager->getPage() > 1) { ?>
            <?=link_to('предыдущая', '@auction_list_status_page?status=closed&page=' . $pager->getPreviousPage())?>
        <?php } ?>

        <?php foreach ($pager->getLinks() as $page) { ?>

            <?php if ($page == $pager->getPage()) { ?>
                <span><?=$page?></span>
            <?php } else { ?>
                <?=link_to($page, '@auction_list_status_page?status=closed&page=' . $page)?>
            <?php } ?>

        <?php } ?>

        <?php if ($pager->getLastPage() != $pager->getPage()) { ?>
            <?=link_to('следующая', '@auction_list_status_page?status=closed&page=' . $pager->getNextPage())?>
        <?php } ?>

    </div>

<?php } ?>