<?php

class AuctionComponents extends sfActions
{
    public function executeListIndex (sfWebRequest $request)
    {
        $cacheKey = 'LOT_IDS_LIST_SHORT';
        if (!sfCacheManager::has($cacheKey)) {

            $c = new Criteria();
            $c->add(LotPeer::IS_CLOSED, false);
            $c->addAscendingOrderByColumn(LotPeer::DT_END);
            $c->setLimit(3);

            $lots = LotPeer::doSelect($c);

            $this->lotIds = array();
            foreach ($lots as $lot)
                $this->lotIds[] = $lot->getId();

            sfCacheManager::set($cacheKey, $this->lotIds, array('LotList'));

        } else {

            $this->lotIds = sfCacheManager::get($cacheKey);

        }

        $cacheKey = 'LOT_IDS_LIST_EXCEPT_SHORT';
        if (!sfCacheManager::has($cacheKey)) {

            $c = new Criteria();
            $c->add(LotPeer::IS_CLOSED, false);
            $c->add(LotPeer::ID, $this->lotIds, Criteria::NOT_IN);
            $c->addAscendingOrderByColumn(LotPeer::DT_END);

            $lots = LotPeer::doSelect($c);

            $this->lotExceptIds = array();
            foreach ($lots as $lot)
                $this->lotExceptIds[] = $lot->getId();

            sfCacheManager::set($cacheKey, $this->lotExceptIds, array('LotList'));

        } else {

            $this->lotExceptIds = sfCacheManager::get($cacheKey);

        }
    }

    public function executeListOthers (sfWebRequest $request)
    {
        $cacheKey = 'LOT_IDS_LIST_SHORT_OTHER_' . $this->lotActiveId;
        if (!sfCacheManager::has($cacheKey)) {

            $c = new Criteria();
            $c->add(LotPeer::IS_CLOSED, false);
            $c->add(LotPeer::ID, $this->lotActiveId, Criteria::NOT_EQUAL);
            $c->addAscendingOrderByColumn(LotPeer::DT_START);
            $c->setLimit(3);

            $lots = LotPeer::doSelect($c);

            $this->lotIds = array();
            foreach ($lots as $lot)
                $this->lotIds[] = $lot->getId();

            sfCacheManager::set($cacheKey, $this->lotIds, array('LotList'));

        } else {

            $this->lotIds = sfCacheManager::get($cacheKey);

        }
    }

    public function executeLastWinner (sfWebRequest $request)
    {
        $cacheKey = 'LOT_LAST_CLOSED_UPD';
        if (!sfCacheManager::has($cacheKey)) {

            $c = new Criteria();
            $c->add(LotPeer::IS_CLOSED, true);
            $c->add(LotPeer::ID, 88, Criteria::NOT_EQUAL);
            $c->addDescendingOrderByColumn(LotPeer::DT_END);
            $c->setLimit(1);

            $this->lot = LotPeer::doSelectOne($c);

            sfCacheManager::set($cacheKey, $this->lot, array('LotList'));

        } else {

            $this->lot = sfCacheManager::get($cacheKey);

        }
    }
}