<?php

/**
 * Auction actions.
 *
 * @package    auction
 * @subpackage Auction
 * @author     Your name here
 * @version    SVN: $Id: actions.class.php 12479 2008-10-31 10:54:40Z fabien $
 */
class AuctionActions extends sfActions
{
    public function executeIndex (sfWebRequest $request)
    {
        $this->getResponse()->setTitle(sfConfig::get('app_meta_title') . ' &mdash; первая система скандинавских аукционов в Беларуси', false);
    }

    public function executeList (sfWebRequest $request)
    {
        $this->forward404Unless(!$request->hasParameter('status') || 'active' == $request->getParameter('status') || 'closed' == $request->getParameter('status'));

        $this->pageTitle = 'Аукционы';
        $this->breadcrumb = array(array('Аукционы', ''));
        $this->getResponse()->setTitle('Аукционы' . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

        $c = new Criteria();

        if ('closed' == $request->getParameter('status', 'active')) {

            $c->add(LotPeer::IS_CLOSED, true);
            $c->addDescendingOrderByColumn(LotPeer::DT_END);

        } else {

            $c->add(LotPeer::IS_CLOSED, false);
            $c->addAscendingOrderByColumn(LotPeer::DT_END);

        }

        $this->pager = new sfCachePager('Lot', 'LotList', 10);
        $this->pager->setCriteria($c);
        $this->pager->setPage($request->getParameter('page', 1));
        $this->pager->init();

        return ucfirst($request->getParameter('status', 'active'));
    }

    public function executeView (sfWebRequest $request)
    {
        $this->forward404Unless($request->hasParameter('lotId'));

        $this->lot = sfCacheManager::getObject('Lot', $request->getParameter('lotId'));
        $this->forward404Unless($this->lot);

        $this->product = sfCacheManager::getObject('Product', $this->lot->getProductId());
        $this->forward404Unless($this->product);

        $this->betLast = sfCacheManager::getObject('Bet', $this->lot->getBetLastId());

        // История ставок
        $cacheKey = 'BETS_HISTORY_LOT_' . $this->lot->getId();
        if (!sfCacheManager::has($cacheKey)) {

            $c = new Criteria();
            $c->add(BetPeer::LOT_ID, $this->lot->getId());
            //$c->addDescendingOrderByColumn(BetPeer::DT_CREATED);
            $c->addDescendingOrderByColumn(BetPeer::ID);
            $c->setLimit(5);

            $this->bets = BetPeer::doSelect($c);

            sfCacheManager::set($cacheKey, $this->bets, array('BetList'));

        } else {

            $this->bets = sfCacheManager::get($cacheKey);

        }

        // Автоставка пользователя
        $this->lotAutobet = null;

        if ($this->getUser()->isMember()) {

            $cacheKey = 'AUTOBET_LOT_' . $this->lot->getId() . '_USER_' . $this->getUser()->getGuardUser()->getId();
            if (!sfCacheManager::has($cacheKey)) {

                $c = new Criteria();
                $c->add(LotAutobetPeer::USER_ID, $this->getUser()->getGuardUser()->getId());
                $c->add(LotAutobetPeer::LOT_ID, $this->lot->getId());
                $c->add(LotAutobetPeer::BETS_LIMIT, LotAutobetPeer::BETS_LIMIT . ' > ' . LotAutobetPeer::BETS_COMPLETED, Criteria::CUSTOM);

                $this->lotAutobet = LotAutobetPeer::doSelectOne($c);

                sfCacheManager::set($cacheKey, $this->lotAutobet, array('LotList', 'LotAutobetList'), 24 * 3600);

            } else {

                $this->lotAutobet = sfCacheManager::get($cacheKey);

            }

        }

        $this->getRequest()->setAttribute('lotActiveId', $this->lot->getId());

        $this->pageTitle = $this->product->getTitle();
        $this->breadcrumb = array(array('Аукционы', 'Auction/list'), array($this->product->getTitle(), ''));
        $this->getResponse()->setTitle($this->product->getTitle() . ' &mdash; ' . sfConfig::get('app_meta_title'), false);

    }

    public function executeViewHistory (sfWebRequest $request)
    {
        $this->forward404Unless($request->hasParameter('lotId'));

        $this->lot = sfCacheManager::getObject('Lot', $request->getParameter('lotId'));
        $this->forward404Unless($this->lot);
        $this->forward404Unless($this->lot->getIsClosed());

        $this->product = sfCacheManager::getObject('Product', $this->lot->getProductId());
        $this->forward404Unless($this->product);

        $c = new Criteria();
        $c->add(BetPeer::LOT_ID, $this->lot->getId());
//        $c->addDescendingOrderByColumn(BetPeer::DT_CREATED);
        $c->addDescendingOrderByColumn(BetPeer::ID);

        $this->pager = new sfCachePager('Bet', 'BetList', 20);
        $this->pager->setCriteria($c);
        $this->pager->setPage($request->getParameter('page', 1));
        $this->pager->init();

        $this->pageTitle = $this->product->getTitle() . ' &mdash; история';
        $this->breadcrumb = array(array('Аукционы', 'Auction/list'), array($this->product->getTitle(), '@auction_view?lotId=' . $this->lot->getId(), array('История ставок', '')));
        $this->getResponse()->setTitle('История ставок &mdash; ' . $this->product->getTitle() . ' &mdash; ' . sfConfig::get('app_meta_title'), false);
    }
}
